/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import mockit.Injectable;
import mockit.NonStrictExpectations;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.compile.CodeCompiler;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import org.apache.drill.exec.physical.impl.SimpleRootExec;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestMergeJoin
extends PopUnitTestBase {
    private final DrillConfig c = DrillConfig.create();

    @Test
    @Ignore
    public void simpleEqualityJoin(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestMergeJoin.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestMergeJoin.this.c);
                bitContext.getConfig();
                result = TestMergeJoin.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestMergeJoin.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/join/merge_join.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        int totalRecordCount = 0;
        while (exec.next()) {
            totalRecordCount += exec.getRecordCount();
            for (ValueVector v : exec) {
                System.out.print("[" + v.getField().toExpr() + "]        ");
            }
            System.out.println("\n");
            for (int valueIdx = 0; valueIdx < exec.getRecordCount(); ++valueIdx) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (ValueVector v : exec) {
                    row.add(v.getAccessor().getObject(valueIdx));
                }
                for (Object cell : row) {
                    if (cell == null) {
                        System.out.print("<null>          ");
                        continue;
                    }
                    int len = cell.toString().length();
                    System.out.print(cell);
                    for (int i = 0; i < 14 - len; ++i) {
                        System.out.print(" ");
                    }
                }
                System.out.println();
            }
            System.out.println();
        }
        Assert.assertEquals((long)100L, (long)totalRecordCount);
        System.out.println("Total Record Count: " + totalRecordCount);
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    @Ignore
    public void orderedEqualityLeftJoin(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestMergeJoin.this.c);
                bitContext.getConfig();
                result = TestMergeJoin.this.c;
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestMergeJoin.this.c);
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestMergeJoin.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance(), new StoragePluginRegistry(bitContext));
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/join/merge_single_batch.json"), (Charset)Charsets.UTF_8).replace("#{LEFT_FILE}", FileUtils.getResourceAsFile((String)"/join/merge_single_batch.left.json").toURI().toString()).replace("#{RIGHT_FILE}", FileUtils.getResourceAsFile((String)"/join/merge_single_batch.right.json").toURI().toString()));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        int totalRecordCount = 0;
        while (exec.next()) {
            System.out.println("got next with record count: " + exec.getRecordCount() + " (total: " + (totalRecordCount += exec.getRecordCount()) + "):");
            System.out.println("       t1                 t2");
            for (int valueIdx = 0; valueIdx < exec.getRecordCount(); ++valueIdx) {
                ArrayList row = Lists.newArrayList();
                for (ValueVector v : exec) {
                    row.add(v.getField().toExpr() + ":" + v.getAccessor().getObject(valueIdx));
                }
                for (Object cell : row) {
                    if (cell == null) {
                        System.out.print("<null>    ");
                        continue;
                    }
                    int len = cell.toString().length();
                    System.out.print(cell + " ");
                    for (int i = 0; i < 10 - len; ++i) {
                        System.out.print(" ");
                    }
                }
                System.out.println();
            }
        }
        System.out.println("Total Record Count: " + totalRecordCount);
        Assert.assertEquals((long)25L, (long)totalRecordCount);
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    @Ignore
    public void orderedEqualityInnerJoin(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestMergeJoin.this.c);
                bitContext.getConfig();
                result = TestMergeJoin.this.c;
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestMergeJoin.this.c);
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestMergeJoin.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance(), new StoragePluginRegistry(bitContext));
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/join/merge_inner_single_batch.json"), (Charset)Charsets.UTF_8).replace("#{LEFT_FILE}", FileUtils.getResourceAsFile((String)"/join/merge_single_batch.left.json").toURI().toString()).replace("#{RIGHT_FILE}", FileUtils.getResourceAsFile((String)"/join/merge_single_batch.right.json").toURI().toString()));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        int totalRecordCount = 0;
        while (exec.next()) {
            System.out.println("got next with record count: " + exec.getRecordCount() + " (total: " + (totalRecordCount += exec.getRecordCount()) + "):");
            System.out.println("       t1                 t2");
            for (int valueIdx = 0; valueIdx < exec.getRecordCount(); ++valueIdx) {
                ArrayList row = Lists.newArrayList();
                for (ValueVector v : exec) {
                    row.add(v.getField().toExpr() + ":" + v.getAccessor().getObject(valueIdx));
                }
                for (Object cell : row) {
                    if (cell == null) {
                        System.out.print("<null>    ");
                        continue;
                    }
                    int len = cell.toString().length();
                    System.out.print(cell + " ");
                    for (int i = 0; i < 10 - len; ++i) {
                        System.out.print(" ");
                    }
                }
                System.out.println();
            }
        }
        System.out.println("Total Record Count: " + totalRecordCount);
        Assert.assertEquals((long)23L, (long)totalRecordCount);
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    @Ignore
    public void orderedEqualityMultiBatchJoin(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestMergeJoin.this.c);
                bitContext.getConfig();
                result = TestMergeJoin.this.c;
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestMergeJoin.this.c);
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestMergeJoin.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance(), new StoragePluginRegistry(bitContext));
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/join/merge_multi_batch.json"), (Charset)Charsets.UTF_8).replace("#{LEFT_FILE}", FileUtils.getResourceAsFile((String)"/join/merge_multi_batch.left.json").toURI().toString()).replace("#{RIGHT_FILE}", FileUtils.getResourceAsFile((String)"/join/merge_multi_batch.right.json").toURI().toString()));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        int totalRecordCount = 0;
        while (exec.next()) {
            System.out.println("got next with record count: " + exec.getRecordCount() + " (total: " + (totalRecordCount += exec.getRecordCount()) + "):");
            for (int valueIdx = 0; valueIdx < exec.getRecordCount(); ++valueIdx) {
                ArrayList row = Lists.newArrayList();
                for (ValueVector v : exec) {
                    row.add(v.getField().toExpr() + ":" + v.getAccessor().getObject(valueIdx));
                }
                for (Object cell : row) {
                    if (cell == null) {
                        System.out.print("<null>    ");
                        continue;
                    }
                    int len = cell.toString().length();
                    System.out.print(cell + " ");
                    for (int i = 0; i < 10 - len; ++i) {
                        System.out.print(" ");
                    }
                }
                System.out.println();
            }
        }
        System.out.println("Total Record Count: " + totalRecordCount);
        Assert.assertEquals((long)25L, (long)totalRecordCount);
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void testJoinBatchSize(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestMergeJoin.this.c);
                bitContext.getConfig();
                result = TestMergeJoin.this.c;
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestMergeJoin.this.c);
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestMergeJoin.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/join/join_batchsize.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        exec.next();
        while (exec.next()) {
            Assert.assertEquals((long)100L, (long)exec.getRecordCount());
        }
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void testMergeJoinInnerEmptyBatch() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/join/merge_join_empty_batch.json"), (Charset)Charsets.UTF_8).replace("${JOIN_TYPE}", "INNER"));
            int count = 0;
            for (QueryDataBatch b : results) {
                if (b.getHeader().getRowCount() != 0) {
                    count += b.getHeader().getRowCount();
                }
                b.release();
            }
            Assert.assertEquals((long)0L, (long)count);
        }
    }

    @Test
    public void testMergeJoinLeftEmptyBatch() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/join/merge_join_empty_batch.json"), (Charset)Charsets.UTF_8).replace("${JOIN_TYPE}", "LEFT"));
            int count = 0;
            for (QueryDataBatch b : results) {
                if (b.getHeader().getRowCount() != 0) {
                    count += b.getHeader().getRowCount();
                }
                b.release();
            }
            Assert.assertEquals((long)50L, (long)count);
        }
    }

    @Test
    public void testMergeJoinRightEmptyBatch() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/join/merge_join_empty_batch.json"), (Charset)Charsets.UTF_8).replace("${JOIN_TYPE}", "RIGHT"));
            int count = 0;
            for (QueryDataBatch b : results) {
                if (b.getHeader().getRowCount() != 0) {
                    count += b.getHeader().getRowCount();
                }
                b.release();
            }
            Assert.assertEquals((long)0L, (long)count);
        }
    }

    @Test
    public void testMergeJoinExprInCondition() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/join/mergeJoinExpr.json"), (Charset)Charsets.UTF_8));
            int count = 0;
            for (QueryDataBatch b : results) {
                if (b.getHeader().getRowCount() != 0) {
                    count += b.getHeader().getRowCount();
                }
                b.release();
            }
            Assert.assertEquals((long)10L, (long)count);
        }
    }
}

