/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import org.apache.drill.BaseTestQuery;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHashJoinAdvanced
extends BaseTestQuery {
    @BeforeClass
    public static void disableMergeJoin() throws Exception {
        TestHashJoinAdvanced.test("alter session set `planner.enable_mergejoin` = false");
    }

    @AfterClass
    public static void enableMergeJoin() throws Exception {
        TestHashJoinAdvanced.test("alter session set `planner.enable_mergejoin` = true");
    }

    @Test
    public void testLeftSelfHashJoinWithMap() throws Exception {
        String query = " select a.id, b.oooi.oa.oab.oabc oabc, b.ooof.oa.oab oab from cp.`join/complex_1.json` a left outer join cp.`join/complex_1.json` b on a.id=b.id order by a.id";
        TestHashJoinAdvanced.testBuilder().sqlQuery(" select a.id, b.oooi.oa.oab.oabc oabc, b.ooof.oa.oab oab from cp.`join/complex_1.json` a left outer join cp.`join/complex_1.json` b on a.id=b.id order by a.id").unOrdered().jsonBaselineFile("join/DRILL-2197-result-1.json").build().run();
    }

    @Test
    public void testLeftHashJoinWithMap() throws Exception {
        String query = " select a.id, b.oooi.oa.oab.oabc oabc, b.ooof.oa.oab oab from cp.`join/complex_1.json` a left outer join cp.`join/complex_2.json` b on a.id=b.id order by a.id";
        TestHashJoinAdvanced.testBuilder().sqlQuery(" select a.id, b.oooi.oa.oab.oabc oabc, b.ooof.oa.oab oab from cp.`join/complex_1.json` a left outer join cp.`join/complex_2.json` b on a.id=b.id order by a.id").unOrdered().jsonBaselineFile("join/DRILL-2197-result-2.json").build().run();
    }

    @Test
    public void testFOJWithRequiredTypes() throws Exception {
        String query = "select t1.varchar_col from cp.`parquet/drill-2707_required_types.parquet` t1 full outer join cp.`parquet/alltypes.json` t2 on t1.int_col = t2.INT_col order by t1.varchar_col limit 1";
        TestHashJoinAdvanced.testBuilder().sqlQuery(query).ordered().baselineColumns("varchar_col").baselineValues("doob").go();
    }

    @Test
    public void testRightJoinWithMap() throws Exception {
        String query = " select a.id, b.oooi.oa.oab.oabc oabc, b.ooof.oa.oab oab from cp.`join/complex_1.json` b right outer join cp.`join/complex_1.json` a on a.id = b.id order by a.id";
        TestHashJoinAdvanced.testBuilder().sqlQuery(" select a.id, b.oooi.oa.oab.oabc oabc, b.ooof.oa.oab oab from cp.`join/complex_1.json` b right outer join cp.`join/complex_1.json` a on a.id = b.id order by a.id").unOrdered().jsonBaselineFile("join/DRILL-2197-result-1.json").build().run();
    }

    @Test
    public void testJoinWithDifferentTypesInCondition() throws Exception {
        String query = "select t1.full_name from cp.`employee.json` t1, cp.`department.json` t2 where cast(t1.department_id as double) = t2.department_id and t1.employee_id = 1";
        TestHashJoinAdvanced.testBuilder().sqlQuery(query).optionSettingQueriesForTestQuery("alter session set `planner.enable_hashjoin` = true").unOrdered().baselineColumns("full_name").baselineValues("Sheri Nowmer").go();
        query = "select t1.bigint_col from cp.`jsoninput/implicit_cast_join_1.json` t1, cp.`jsoninput/implicit_cast_join_1.json` t2  where t1.bigint_col = cast(t2.bigint_col as int) and t1.double_col  = cast(t2.double_col as float) and t1.bigint_col = cast(t2.bigint_col as double)";
        TestHashJoinAdvanced.testBuilder().sqlQuery(query).optionSettingQueriesForTestQuery("alter session set `planner.enable_hashjoin` = true").unOrdered().baselineColumns("bigint_col").baselineValues(1L).go();
        query = "select count(*) col1 from (select t1.date_opt from cp.`parquet/date_dictionary.parquet` t1, cp.`parquet/timestamp_table.parquet` t2 where t1.date_opt = t2.timestamp_col)";
        TestHashJoinAdvanced.testBuilder().sqlQuery(query).unOrdered().baselineColumns("col1").baselineValues(4L).go();
    }
}

