/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import mockit.Injectable;
import mockit.NonStrictExpectations;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.compile.CodeCompiler;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import org.apache.drill.exec.physical.impl.SimpleRootExec;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.server.options.SystemOptionManager;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.apache.drill.exec.store.sys.local.LocalPStoreProvider;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class TestHashJoin
extends PopUnitTestBase {
    @Rule
    public final TestRule TIMEOUT = TestTools.getTimeoutRule((int)100000);
    private final DrillConfig c = DrillConfig.create();

    private void testHJMockScanCommon(final DrillbitContext bitContext, UserServer.UserClientConnection connection, String physicalPlan, int expectedRows) throws Throwable {
        LocalPStoreProvider provider = new LocalPStoreProvider(this.c);
        provider.start();
        final SystemOptionManager opt = new SystemOptionManager(this.c, (PStoreProvider)provider);
        opt.init();
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestHashJoin.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestHashJoin.this.c);
                bitContext.getConfig();
                result = TestHashJoin.this.c;
                bitContext.getOptionManager();
                result = opt;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestHashJoin.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)physicalPlan), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        int totalRecordCount = 0;
        while (exec.next()) {
            totalRecordCount += exec.getRecordCount();
        }
        exec.close();
        Assert.assertEquals((long)expectedRows, (long)totalRecordCount);
        System.out.println("Total Record Count: " + totalRecordCount);
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void multiBatchEqualityJoin(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        this.testHJMockScanCommon(bitContext, connection, "/join/hash_join_multi_batch.json", 200000);
    }

    @Test
    public void multiBatchRightOuterJoin(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        this.testHJMockScanCommon(bitContext, connection, "/join/hj_right_outer_multi_batch.json", 100000);
    }

    @Test
    public void multiBatchLeftOuterJoin(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        this.testHJMockScanCommon(bitContext, connection, "/join/hj_left_outer_multi_batch.json", 100000);
    }

    @Test
    public void simpleEqualityJoin() throws Throwable {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/join/hash_join.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE_1}", FileUtils.getResourceAsFile((String)"/build_side_input.json").toURI().toString()).replace("#{TEST_FILE_2}", FileUtils.getResourceAsFile((String)"/probe_side_input.json").toURI().toString()));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(1);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            Iterator itr = batchLoader.iterator();
            long[] colA = new long[]{1L, 1L, 2L, 2L, 1L, 1L};
            ValueVector.Accessor intAccessor1 = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            for (int i = 0; i < intAccessor1.getValueCount(); ++i) {
                Assert.assertEquals((Object)intAccessor1.getObject(i), (Object)colA[i]);
            }
            Assert.assertEquals((long)6L, (long)intAccessor1.getValueCount());
            batchLoader.clear();
            for (QueryDataBatch result : results) {
                result.release();
            }
        }
    }

    @Test
    public void hjWithExchange(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/join/hj_exchanges.json"), (Charset)Charsets.UTF_8));
            int count = 0;
            for (QueryDataBatch b : results) {
                if (b.getHeader().getRowCount() != 0) {
                    count += b.getHeader().getRowCount();
                }
                b.release();
            }
            System.out.println("Total records: " + count);
            Assert.assertEquals((long)25L, (long)count);
        }
    }

    @Test
    public void multipleConditionJoin(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/join/hj_multi_condition_join.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE_1}", FileUtils.getResourceAsFile((String)"/build_side_input.json").toURI().toString()).replace("#{TEST_FILE_2}", FileUtils.getResourceAsFile((String)"/probe_side_input.json").toURI().toString()));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(1);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            Iterator itr = batchLoader.iterator();
            long[] colA = new long[]{1L, 2L, 1L};
            long[] colC = new long[]{100L, 200L, 500L};
            ValueVector.Accessor intAccessor1 = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            ValueVector.Accessor intAccessor2 = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            for (int i = 0; i < intAccessor1.getValueCount(); ++i) {
                Assert.assertEquals((Object)intAccessor1.getObject(i), (Object)colA[i]);
                Assert.assertEquals((Object)intAccessor2.getObject(i), (Object)colC[i]);
            }
            Assert.assertEquals((long)3L, (long)intAccessor1.getValueCount());
            batchLoader.clear();
            for (QueryDataBatch result : results) {
                result.release();
            }
        }
    }

    @Test
    public void hjWithExchange1(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/join/hj_exchanges1.json"), (Charset)Charsets.UTF_8));
            int count = 0;
            for (QueryDataBatch b : results) {
                if (b.getHeader().getRowCount() != 0) {
                    count += b.getHeader().getRowCount();
                }
                b.release();
            }
            System.out.println("Total records: " + count);
            Assert.assertEquals((long)272L, (long)count);
        }
    }

    @Test
    public void testHashJoinExprInCondition() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/join/hashJoinExpr.json"), (Charset)Charsets.UTF_8));
            int count = 0;
            for (QueryDataBatch b : results) {
                if (b.getHeader().getRowCount() != 0) {
                    count += b.getHeader().getRowCount();
                }
                b.release();
            }
            Assert.assertEquals((long)10L, (long)count);
        }
    }
}

