/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.flatten;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.TestBuilder;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.fn.interp.TestConstantFolding;
import org.apache.drill.exec.util.JsonStringHashMap;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestFlatten
extends BaseTestQuery {
    public static boolean RUN_ADVANCED_TESTS = false;
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testFlattenFailure() throws Exception {
        TestFlatten.test("select flatten(complex), rownum from cp.`/store/json/test_flatten_mappify2.json`");
    }

    @Test
    public void testFlatten_Drill2162_complex() throws Exception {
        String path = this.folder.getRoot().toPath().toString();
        String jsonRecords = BaseTestQuery.getFile("flatten/complex_transaction_example_data.json");
        int numCopies = 700;
        new TestConstantFolding.SmallFileCreator(this.folder).setRecord(jsonRecords).createFiles(1, numCopies, "json");
        ArrayList data = Lists.newArrayList((Object[])new JsonStringHashMap[]{TestBuilder.mapOf("uid", 1L, "lst_lst_0", TestBuilder.listOf(1L, 2L, 3L, 4L, 5L), "lst_lst_1", TestBuilder.listOf(2L, 3L, 4L, 5L, 6L), "lst_lst", TestBuilder.listOf(TestBuilder.listOf(1L, 2L, 3L, 4L, 5L), TestBuilder.listOf(2L, 3L, 4L, 5L, 6L))), TestBuilder.mapOf("uid", 2L, "lst_lst_0", TestBuilder.listOf(1L, 2L, 3L, 4L, 5L), "lst_lst_1", TestBuilder.listOf(2L, 3L, 4L, 5L, 6L), "lst_lst", TestBuilder.listOf(TestBuilder.listOf(1L, 2L, 3L, 4L, 5L), TestBuilder.listOf(2L, 3L, 4L, 5L, 6L)))});
        List<JsonStringHashMap<String, Object>> result = this.flatten(this.flatten(this.flatten(data, "lst_lst_1"), "lst_lst_0"), "lst_lst");
        TestBuilder builder = TestFlatten.testBuilder().sqlQuery("select uid, flatten(d.lst_lst[1]) lst1, flatten(d.lst_lst[0]) lst0, flatten(d.lst_lst) lst from dfs.`" + path + "/bigfile/bigfile.json` d").unOrdered().baselineColumns("uid", "lst1", "lst0", "lst");
        for (int i = 0; i < numCopies; ++i) {
            for (JsonStringHashMap<String, Object> record : result) {
                builder.baselineValues(record.get((Object)"uid"), record.get((Object)"lst_lst_1"), record.get((Object)"lst_lst_0"), record.get((Object)"lst_lst"));
            }
        }
        builder.go();
    }

    @Test
    public void testFlattenReferenceImpl() throws Exception {
        ArrayList data = Lists.newArrayList((Object[])new JsonStringHashMap[]{TestBuilder.mapOf("a", 1, "b", 2, "list_col", TestBuilder.listOf(10, 9), "nested_list_col", TestBuilder.listOf(TestBuilder.listOf(100, 99), TestBuilder.listOf(1000, 999)))});
        List<JsonStringHashMap<String, Object>> result = this.flatten(this.flatten(this.flatten(data, "list_col"), "nested_list_col"), "nested_list_col");
        ArrayList expectedResult = Lists.newArrayList((Object[])new JsonStringHashMap[]{TestBuilder.mapOf("nested_list_col", 100, "list_col", 10, "a", 1, "b", 2), TestBuilder.mapOf("nested_list_col", 99, "list_col", 10, "a", 1, "b", 2), TestBuilder.mapOf("nested_list_col", 1000, "list_col", 10, "a", 1, "b", 2), TestBuilder.mapOf("nested_list_col", 999, "list_col", 10, "a", 1, "b", 2), TestBuilder.mapOf("nested_list_col", 100, "list_col", 9, "a", 1, "b", 2), TestBuilder.mapOf("nested_list_col", 99, "list_col", 9, "a", 1, "b", 2), TestBuilder.mapOf("nested_list_col", 1000, "list_col", 9, "a", 1, "b", 2), TestBuilder.mapOf("nested_list_col", 999, "list_col", 9, "a", 1, "b", 2)});
        int i = 0;
        for (JsonStringHashMap<String, Object> record : result) {
            Assert.assertEquals(record, expectedResult.get(i));
            ++i;
        }
    }

    private List<JsonStringHashMap<String, Object>> flatten(List<JsonStringHashMap<String, Object>> incomingRecords, String colToFlatten) {
        return this.flatten(incomingRecords, colToFlatten, colToFlatten);
    }

    private List<JsonStringHashMap<String, Object>> flatten(List<JsonStringHashMap<String, Object>> incomingRecords, String colToFlatten, String flattenedDataColName) {
        ArrayList output = Lists.newArrayList();
        for (JsonStringHashMap<String, Object> incomingRecord : incomingRecords) {
            List dataToFlatten = (List)incomingRecord.get((Object)colToFlatten);
            for (int i = 0; i < dataToFlatten.size(); ++i) {
                JsonStringHashMap newRecord = new JsonStringHashMap();
                newRecord.put((Object)flattenedDataColName, dataToFlatten.get(i));
                for (String s : incomingRecord.keySet()) {
                    if (s.equals(colToFlatten)) continue;
                    newRecord.put((Object)s, incomingRecord.get((Object)s));
                }
                output.add(newRecord);
            }
        }
        return output;
    }

    @Test
    public void testFlatten_Drill2162_simple() throws Exception {
        String path = this.folder.getRoot().toPath().toString();
        ArrayList inputList = Lists.newArrayList();
        String jsonRecord = "{ \"int_list\" : [";
        int listSize = 30;
        for (int i = 1; i < 30; ++i) {
            jsonRecord = jsonRecord + i + ", ";
            inputList.add(Long.valueOf(i));
        }
        jsonRecord = jsonRecord + "30] }";
        inputList.add(30L);
        int numRecords = 3000;
        new TestConstantFolding.SmallFileCreator(this.folder).setRecord(jsonRecord).createFiles(1, numRecords, "json");
        ArrayList data = Lists.newArrayList((Object[])new JsonStringHashMap[]{TestBuilder.mapOf("int_list", inputList)});
        List<JsonStringHashMap<String, Object>> result = this.flatten(data, "int_list");
        TestBuilder builder = TestFlatten.testBuilder().sqlQuery("select flatten(int_list) as int_list from dfs.`" + path + "/bigfile/bigfile.json`").unOrdered().baselineColumns("int_list");
        for (int i = 0; i < numRecords; ++i) {
            for (JsonStringHashMap<String, Object> record : result) {
                builder.baselineValues(record.get((Object)"int_list"));
            }
        }
        builder.go();
    }

    @Test
    public void drill1671() throws Exception {
        int rowCount = TestFlatten.testSql("select * from (select count(*) as cnt from (select id, flatten(evnts1), flatten(evnts2), flatten(evnts3), flatten(evnts4), flatten(evnts5), flatten(evnts6), flatten(evnts7), flatten(evnts8), flatten(evnts9), flatten(evnts10), flatten(evnts11) from cp.`/flatten/many-arrays-50.json`)x )y where cnt = 2048");
        Assert.assertEquals((long)rowCount, (long)1L);
    }

    @Test
    public void drill3370() throws Exception {
        TestFlatten.testBuilder().sqlQuery("select a from (select flatten(arr) as a from cp.`/flatten/drill-3370.json`) where a > 100").unOrdered().baselineColumns("a").baselineValues(131L).baselineValues(106L).go();
    }

    @Test
    @Ignore(value="not yet fixed")
    public void drill1660() throws Exception {
        TestFlatten.test("select * from cp.`/flatten/empty-rm.json`");
    }

    @Test
    public void drill1673() throws Exception {
        String path = this.folder.getRoot().toPath().toString();
        String jsonRecords = BaseTestQuery.getFile("store/json/1673.json");
        int numCopies = 25000;
        new TestConstantFolding.SmallFileCreator(this.folder).setRecord(jsonRecords).createFiles(1, numCopies, "json");
        TestBuilder builder = TestFlatten.testBuilder().sqlQuery("select t.fixed_column as fixed_column, flatten(t.list_column) as list_col from dfs.`" + path + "/bigfile/bigfile.json` as t").baselineColumns("fixed_column", "list_col").unOrdered();
        JsonStringHashMap<String, Object> map1 = TestBuilder.mapOf("id1", "1", "name", "zhu", "num", TestBuilder.listOf(TestBuilder.listOf(1L, 2L, 3L)));
        JsonStringHashMap<String, Object> map2 = TestBuilder.mapOf("id1", "2", "name", "hao", "num", TestBuilder.listOf(TestBuilder.listOf(4L, 5L, 6L)));
        for (int i = 0; i < numCopies; ++i) {
            builder.baselineValues("abc", map1);
            builder.baselineValues("abc", map2);
        }
        builder.go();
    }

    @Test
    public void drill1653() throws Exception {
        int rowCount = TestFlatten.testSql("select * from (select sum(t.flat.`value`) as sm from (select id, flatten(kvgen(m)) as flat from cp.`/flatten/missing-map.json`)t) where sm = 10 ");
        Assert.assertEquals((long)1L, (long)rowCount);
    }

    @Test
    public void drill1652() throws Exception {
        if (RUN_ADVANCED_TESTS) {
            TestFlatten.test("select uid, flatten(transactions) from dfs.`/tmp/bigfile.json`");
        }
    }

    @Test
    @Ignore(value="Still not working.")
    public void drill1649() throws Exception {
        TestFlatten.test("select event_info.uid, transaction_info.trans_id, event_info.event.evnt_id\nfrom (\n select userinfo.transaction.trans_id trans_id, max(userinfo.event.event_time) max_event_time\n from (\n     select uid, flatten(events) event, flatten(transactions) transaction from cp.`/flatten/single-user-transactions.json`\n ) userinfo\n where userinfo.transaction.trans_time >= userinfo.event.event_time\n group by userinfo.transaction.trans_id\n) transaction_info\ninner join\n(\n select uid, flatten(events) event\n from cp.`/flatten/single-user-transactions.json`\n) event_info\non transaction_info.max_event_time = event_info.event.event_time;");
    }

    @Test
    public void testKVGenFlatten1() throws Exception {
        TestFlatten.test("select flatten(kvgen(f1)) as monkey, x from cp.`/store/json/test_flatten_mapify.json`");
    }

    @Test
    public void testTwoFlattens() throws Exception {
        TestFlatten.test("select `integer`, `float`, x, flatten(z), flatten(l) from cp.`/jsoninput/input2_modified.json`");
    }

    @Test
    public void testFlattenRepeatedMap() throws Exception {
        TestFlatten.test("select `integer`, `float`, x, flatten(z) from cp.`/jsoninput/input2.json`");
    }

    @Test
    public void testFlattenKVGenFlatten() throws Exception {
        TestFlatten.test("select `integer`, `float`, x, flatten(kvgen(flatten(z))) from cp.`/jsoninput/input2.json`");
    }

    @Test
    public void testKVGenFlatten2() throws Exception {
        if (RUN_ADVANCED_TESTS) {
            TestFlatten.test("select flatten(kvgen(visited_cellid_counts)) as mytb from dfs.`/tmp/mapkv.json`");
        }
    }

    @Test
    public void testFilterFlattenedRecords() throws Exception {
        TestFlatten.test("select t2.key from (select t.monkey.`value` as val, t.monkey.key as key from (select flatten(kvgen(f1)) as monkey, x from cp.`/store/json/test_flatten_mapify.json`) as t) as t2 where t2.val > 1");
    }

    @Test
    public void testFilterFlattenedRecords2() throws Exception {
        if (RUN_ADVANCED_TESTS) {
            TestFlatten.test("select celltbl.catl from (\n        select flatten(categories) catl from dfs.`/tmp/yelp_academic_dataset_business.json` b limit 100\n    )  celltbl where celltbl.catl = 'Doctors'");
        }
    }

    @Test
    public void countAggFlattened() throws Exception {
        if (RUN_ADVANCED_TESTS) {
            TestFlatten.test("select celltbl.catl, count(celltbl.catl) from ( select business_id, flatten(categories) catl from dfs.`/tmp/yelp_academic_dataset_business.json` b limit 100 )  celltbl group by celltbl.catl limit 10 ");
        }
    }

    @Test
    public void flattenAndAdditionalColumn() throws Exception {
        if (RUN_ADVANCED_TESTS) {
            TestFlatten.test("select business_id, flatten(categories) from dfs.`/tmp/yelp_academic_dataset_business.json` b");
        }
    }

    @Test
    public void testFailingFlattenAlone() throws Exception {
        if (RUN_ADVANCED_TESTS) {
            TestFlatten.test("select flatten(categories) from dfs.`/tmp/yelp_academic_dataset_business.json` b  ");
        }
    }

    @Test
    public void testDistinctAggrFlattened() throws Exception {
        if (RUN_ADVANCED_TESTS) {
            TestFlatten.test(" select distinct(celltbl.catl) from (\n        select flatten(categories) catl from dfs.`/tmp/yelp_academic_dataset_business.json` b\n    )  celltbl");
        }
    }

    @Test
    public void testDrill1665() throws Exception {
        if (RUN_ADVANCED_TESTS) {
            TestFlatten.test("select id, flatten(evnts) as rpt from dfs.`/tmp/drill1665.json`");
        }
    }

    @Test
    public void testFlattenComplexRepeatedMap() throws Exception {
        TestFlatten.test("select a, flatten(r_map_1), flatten(r_map_2) from cp.`/store/json/complex_repeated_map.json`");
    }

    @Test
    public void testFlatten2_levelRepeatedMap() throws Exception {
        TestFlatten.test("select flatten(rm) from cp.`/store/json/2_level_repeated_map.json`");
    }

    @Test
    public void testDrill_1770() throws Exception {
        TestFlatten.test("select flatten(sub.fk.`value`) from (select flatten(kvgen(map)) fk from cp.`/store/json/nested_repeated_map.json`) sub");
    }

    @Test
    public void testSingleFlattenFromNestedRepeatedList() throws Exception {
        String query = "select t.uid, flatten(t.odd) odd from cp.`project/complex/a.json` t";
        TestFlatten.testBuilder().sqlQuery("select t.uid, flatten(t.odd) odd from cp.`project/complex/a.json` t").unOrdered().jsonBaselineFile("flatten/drill-2254-result-single.json").build().run();
    }

    @Test
    public void testMultiFlattenFromNestedRepeatedList() throws Exception {
        String query = "select t.uid, flatten(flatten(t.odd)) odd from cp.`project/complex/a.json` t";
        TestFlatten.testBuilder().sqlQuery("select t.uid, flatten(flatten(t.odd)) odd from cp.`project/complex/a.json` t").unOrdered().jsonBaselineFile("flatten/drill-2254-result-multi.json").build().run();
    }

    @Test
    public void testSingleMultiFlattenFromNestedRepeatedList() throws Exception {
        String query = "select t.uid, flatten(t.odd) once, flatten(flatten(t.odd)) twice from cp.`project/complex/a.json` t";
        TestFlatten.testBuilder().sqlQuery("select t.uid, flatten(t.odd) once, flatten(flatten(t.odd)) twice from cp.`project/complex/a.json` t").unOrdered().jsonBaselineFile("flatten/drill-2254-result-mix.json").build().run();
    }

    @Test
    public void testDrill_2013() throws Exception {
        TestFlatten.testBuilder().sqlQuery("select flatten(complex), rownum from cp.`/store/json/test_flatten_mappify2.json` where rownum > 5").expectsEmptyResultSet().build().run();
    }

    @Test
    public void testDRILL_2106() throws Exception {
        TestFlatten.testBuilder().sqlQuery("select rl, flatten(rl) frl from (select `integer`, flatten(rl) as rl from cp.`jsoninput/input2.json`)").unOrdered().jsonBaselineFile("flatten/drill-2106-result.json").go();
        TestFlatten.testBuilder().sqlQuery("select rl, flatten(rl) frl from (select flatten(rl) as rl, `integer` from cp.`jsoninput/input2.json`)").unOrdered().jsonBaselineFile("flatten/drill-2106-result.json").go();
    }

    @Test
    public void testFalttenWithStar() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/sample.json").toURI().toString();
        String q1 = String.format("select *, flatten(j.topping) tt, flatten(j.batters.batter) bb, j.id from dfs_test.`%s` j where j.type = 'donut'", root);
        String q2 = String.format("select *, flatten(j.topping) tt, flatten(j.batters.batter) bb, j.id, j.type from dfs_test.`%s` j where j.type = 'donut'", root);
        TestFlatten.test(q1);
        TestFlatten.test(q2);
    }

    @Test
    public void testMultipleFalttenWithWhereClause() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/sample.json").toURI().toString();
        String q1 = String.format("select flatten(j.topping) tt from dfs_test.`%s` j where j.type = 'donut'", root);
        String q2 = String.format("select j.type, flatten(j.topping) tt from dfs_test.`%s` j where j.type = 'donut'", root);
        TestFlatten.test(q1);
        TestFlatten.test(q2);
    }

    @Test
    public void testFlattenAfterSort() throws Exception {
        String query = "select flatten(s1.rms.rptd) rptds from (select d.uid uid, flatten(d.map.rm) rms from cp.`jsoninput/flatten_post_sort.json` d order by d.uid) s1";
        TestFlatten.testBuilder().sqlQuery(query).unOrdered().jsonBaselineFile("flatten/drill-2099-result.json").go();
    }

    @Test
    public void testFlattenAfterJoin1() throws Exception {
        String query = "select flatten(sub1.events) flat_events  from (select t1.events events from cp.`complex/json/flatten_join.json` t1 inner join cp.`complex/json/flatten_join.json` t2 on t1.id=t2.id) sub1";
        TestFlatten.testBuilder().sqlQuery(query).unOrdered().jsonBaselineFile("complex/drill-2268-1-result.json").go();
    }

    @Test
    public void testFlattenAfterJoin2() throws Exception {
        String query = "select flatten(t1.events) flat_events from cp.`complex/json/flatten_join.json` t1 inner join cp.`complex/json/flatten_join.json` t2 on t1.id=t2.id";
        TestFlatten.testBuilder().sqlQuery(query).unOrdered().jsonBaselineFile("complex/drill-2268-2-result.json").go();
    }

    @Test
    public void testFlattenAfterJoin3() throws Exception {
        String query = "select flatten(sub1.lst_lst) flat_lst_lst from (select t1.lst_lst lst_lst from cp.`complex/json/flatten_join.json` t1 inner join cp.`complex/json/flatten_join.json` t2 on t1.id=t2.id) sub1";
        TestFlatten.testBuilder().sqlQuery(query).unOrdered().jsonBaselineFile("complex/drill-2268-3-result.json").go();
    }

    @Test
    public void testFlattenWithScalarFunc() throws Exception {
        String query = "select flatten(t.l) + 1  as c1 from cp.`/jsoninput/input2.json` t";
        TestFlatten.testBuilder().sqlQuery("select flatten(t.l) + 1  as c1 from cp.`/jsoninput/input2.json` t").unOrdered().baselineColumns("c1").baselineValues(5L).baselineValues(3L).baselineValues(5L).baselineValues(3L).baselineValues(5L).baselineValues(3L).go();
    }
}

