/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.filter;

import org.apache.drill.BaseTestQuery;
import org.junit.Test;

public class TestLargeInClause
extends BaseTestQuery {
    private static String getInIntList(int size) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(i);
        }
        return sb.toString();
    }

    private static String getInDateList(int size) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("DATE '1961-08-26'");
        }
        return sb.toString();
    }

    @Test
    public void queryWith300InConditions() throws Exception {
        TestLargeInClause.test("select * from cp.`employee.json` where id in (" + TestLargeInClause.getInIntList(300) + ")");
    }

    @Test
    public void queryWith50000InConditions() throws Exception {
        TestLargeInClause.test("select * from cp.`employee.json` where id in (" + TestLargeInClause.getInIntList(50000) + ")");
    }

    @Test
    public void queryWith50000DateInConditions() throws Exception {
        TestLargeInClause.test("select * from cp.`employee.json` where cast(birth_date as date) in (" + TestLargeInClause.getInDateList(500) + ")");
    }

    @Test
    public void testStringLiterals() throws Exception {
        String query = "select count(*) as cnt from (select n_name from cp.`tpch/nation.parquet`  where n_name in ('ALGERIA', 'ARGENTINA', 'BRAZIL', 'CANADA', 'EGYPT', 'ETHIOPIA', 'FRANCE', 'GERMANY', 'INDIA', 'INDONESIA', 'IRAN', 'IRAQ', 'JAPAN', 'JORDAN', 'KENYA', 'MOROCCO', 'MOZAMBIQUE', 'PERU', 'CHINA', 'ROMANIA', 'SAUDI ARABIA', 'VIETNAM'))";
        TestLargeInClause.testBuilder().sqlQuery(query).unOrdered().baselineColumns("cnt").baselineValues(22L).go();
    }

    @Test
    public void testExprsInInList() throws Exception {
        String query = "select r_regionkey \nfrom cp.`tpch/region.parquet` \nwhere r_regionkey in \n(1, 1 + 1, 1, 1, 1, \n1, 1 , 1, 1 , 1, \n1, 1 , 1, 1 , 1, \n1, 1 , 1, 1 , 1)";
        TestLargeInClause.testBuilder().sqlQuery(query).ordered().baselineColumns("r_regionkey").baselineValues(1).baselineValues(2).build().run();
    }
}

