/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.common;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import mockit.NonStrictExpectations;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.compile.CodeCompiler;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import org.apache.drill.exec.physical.impl.SimpleRootExec;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.DrillbitContext;

public class TestHashTable
extends ExecTest {
    private final DrillConfig c = DrillConfig.create();

    private SimpleRootExec doTest(final DrillbitContext bitContext, UserServer.UserClientConnection connection, String plan_path) throws Exception {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestHashTable.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestHashTable.this.c);
                bitContext.getConfig();
                result = TestHashTable.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestHashTable.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)plan_path), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        return exec;
    }
}

