/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.agg;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import mockit.Injectable;
import mockit.NonStrictExpectations;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.compile.CodeCompiler;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import org.apache.drill.exec.physical.impl.SimpleRootExec;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.junit.Assert;
import org.junit.Test;

public class TestAgg
extends ExecTest {
    private final DrillConfig c = DrillConfig.create();

    private SimpleRootExec doTest(final DrillbitContext bitContext, UserServer.UserClientConnection connection, String file) throws Exception {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestAgg.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestAgg.this.c);
                bitContext.getConfig();
                result = TestAgg.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestAgg.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)file), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        return exec;
    }

    @Test
    public void oneKeyAgg(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        SimpleRootExec exec = this.doTest(bitContext, connection, "/agg/test1.json");
        while (exec.next()) {
            BigIntVector cnt = (BigIntVector)((Object)exec.getValueVectorById(SchemaPath.getSimplePath((String)"cnt"), BigIntVector.class));
            IntVector key = (IntVector)((Object)exec.getValueVectorById(SchemaPath.getSimplePath((String)"blue"), IntVector.class));
            long[] cntArr = new long[]{10001L, 9999L};
            int[] keyArr = new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
            for (int i = 0; i < exec.getRecordCount(); ++i) {
                Assert.assertEquals((Object)cntArr[i], (Object)cnt.getAccessor().getObject(i));
                Assert.assertEquals((Object)keyArr[i], (Object)key.getAccessor().getObject(i));
            }
        }
        if (exec.getContext().getFailureCause() != null) {
            throw exec.getContext().getFailureCause();
        }
        Assert.assertTrue((!exec.getContext().isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void twoKeyAgg(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        SimpleRootExec exec = this.doTest(bitContext, connection, "/agg/twokey.json");
        while (exec.next()) {
            IntVector key1 = (IntVector)((Object)exec.getValueVectorById(SchemaPath.getSimplePath((String)"key1"), IntVector.class));
            BigIntVector key2 = (BigIntVector)((Object)exec.getValueVectorById(SchemaPath.getSimplePath((String)"key2"), BigIntVector.class));
            BigIntVector cnt = (BigIntVector)((Object)exec.getValueVectorById(SchemaPath.getSimplePath((String)"cnt"), BigIntVector.class));
            NullableBigIntVector total = (NullableBigIntVector)((Object)exec.getValueVectorById(SchemaPath.getSimplePath((String)"total"), NullableBigIntVector.class));
            Integer[] keyArr1 = new Integer[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
            long[] keyArr2 = new long[]{0L, 1L, 2L, 0L, 1L, 2L};
            long[] cntArr = new long[]{34L, 34L, 34L, 34L, 34L, 34L};
            long[] totalArr = new long[]{0L, 34L, 68L, 0L, 34L, 68L};
            for (int i = 0; i < exec.getRecordCount(); ++i) {
                Assert.assertEquals((Object)cntArr[i], (Object)cnt.getAccessor().getObject(i));
                Assert.assertEquals((Object)keyArr1[i], (Object)key1.getAccessor().getObject(i));
                Assert.assertEquals((Object)keyArr2[i], (Object)key2.getAccessor().getObject(i));
                Assert.assertEquals((Object)totalArr[i], (Object)total.getAccessor().getObject(i));
            }
        }
        if (exec.getContext().getFailureCause() != null) {
            throw exec.getContext().getFailureCause();
        }
        Assert.assertTrue((!exec.getContext().isFailed() ? 1 : 0) != 0);
    }
}

