/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.TopN;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.vector.BigIntVector;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSimpleTopN
extends PopUnitTestBase {
    static final Logger logger = LoggerFactory.getLogger(TestSimpleTopN.class);
    DrillConfig c = DrillConfig.create();

    @Test
    public void sortOneKeyAscending() throws Throwable {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             Drillbit bit2 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            bit2.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/topN/one_key_sort.json"), (Charset)Charsets.UTF_8));
            int count = 0;
            for (QueryDataBatch b : results) {
                if (b.getHeader().getRowCount() == 0) continue;
                count += b.getHeader().getRowCount();
            }
            Assert.assertEquals((long)100L, (long)count);
            long previousBigInt = Long.MIN_VALUE;
            int recordCount = 0;
            int batchCount = 0;
            for (QueryDataBatch b : results) {
                if (b.getHeader().getRowCount() == 0) continue;
                ++batchCount;
                RecordBatchLoader loader = new RecordBatchLoader(bit1.getContext().getAllocator());
                loader.load(b.getHeader().getDef(), b.getData());
                BigIntVector c1 = (BigIntVector)loader.getValueAccessorById(BigIntVector.class, loader.getValueVectorId(new SchemaPath("blue", ExpressionPosition.UNKNOWN)).getFieldIds()).getValueVector();
                BigIntVector.Accessor a1 = c1.getAccessor();
                for (int i = 0; i < c1.getAccessor().getValueCount(); ++i) {
                    ++recordCount;
                    Assert.assertTrue((previousBigInt <= a1.get(i) ? 1 : 0) != 0);
                    previousBigInt = a1.get(i);
                }
                loader.clear();
                b.release();
            }
            System.out.println(String.format("Sorted %,d records in %d batches.", recordCount, batchCount));
        }
    }
}

