/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import mockit.Injectable;
import mockit.NonStrictExpectations;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.compile.CodeCompiler;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import org.apache.drill.exec.physical.impl.SimpleRootExec;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.junit.Assert;
import org.junit.Test;

public class TestStringFunctions
extends ExecTest {
    private final DrillConfig c = DrillConfig.create();
    private PhysicalPlanReader reader;
    private FunctionImplementationRegistry registry;
    private FragmentContext context;

    public Object[] getRunResult(SimpleRootExec exec) {
        int size = 0;
        for (ValueVector v : exec) {
            ++size;
        }
        Object[] res = new Object[size];
        int i = 0;
        for (ValueVector v : exec) {
            if (v instanceof VarCharVector) {
                res[i++] = new String(((VarCharVector)v).getAccessor().get(0), Charsets.UTF_8);
                continue;
            }
            res[i++] = v.getAccessor().getObject(0);
        }
        return res;
    }

    public void runTest(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection, Object[] expectedResults, String planPath) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestStringFunctions.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestStringFunctions.this.c);
                bitContext.getConfig();
                result = TestStringFunctions.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestStringFunctions.this.c);
            }
        };
        String planString = Resources.toString((URL)Resources.getResource((String)planPath), (Charset)Charsets.UTF_8);
        if (this.reader == null) {
            this.reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        }
        if (this.registry == null) {
            this.registry = new FunctionImplementationRegistry(this.c);
        }
        if (this.context == null) {
            this.context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, this.registry);
        }
        PhysicalPlan plan = this.reader.readPhysicalPlan(planString);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)this.context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        exec.next();
        while (exec.next()) {
            Object[] res = this.getRunResult(exec);
            Assert.assertEquals((String)"return count does not match", (long)expectedResults.length, (long)res.length);
            for (int i = 0; i < res.length; ++i) {
                Assert.assertEquals((String)String.format("column %s does not match", i), (Object)expectedResults[i], (Object)res[i]);
            }
        }
        if (this.context.getFailureCause() != null) {
            throw this.context.getFailureCause();
        }
        Assert.assertTrue((!this.context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void testCharLength(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{new Long(8L), new Long(0L), new Long(5L), new Long(5L), new Long(8L), new Long(0L), new Long(5L), new Long(5L), new Long(8L), new Long(0L), new Long(5L), new Long(5L)};
        this.runTest(bitContext, connection, expected, "functions/string/testCharLength.json");
    }

    @Test
    public void testLike(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE};
        this.runTest(bitContext, connection, expected, "functions/string/testLike.json");
    }

    @Test
    public void testSimilar(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE};
        this.runTest(bitContext, connection, expected, "functions/string/testSimilar.json");
    }

    @Test
    public void testLtrim(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{"def", "abcdef", "dabc", "", "", ""};
        this.runTest(bitContext, connection, expected, "functions/string/testLtrim.json");
    }

    @Test
    public void testTrim(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{"fghI", "", "", "!", " aaa "};
        this.runTest(bitContext, connection, expected, "functions/string/testTrim.json");
    }

    @Test
    public void testReplace(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{"aABABcdf", "ABABbABbcdf", "aababcdf", "acdf", "ABCD", "abc"};
        this.runTest(bitContext, connection, expected, "functions/string/testReplace.json");
    }

    @Test
    public void testRtrim(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{"abc", "abcdef", "ABd", "", "", ""};
        this.runTest(bitContext, connection, expected, "functions/string/testRtrim.json");
    }

    @Test
    public void testConcat(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{"abcABC", "abc", "ABC", ""};
        this.runTest(bitContext, connection, expected, "functions/string/testConcat.json");
    }

    @Test
    public void testLower(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{"abcefgh", "abc", ""};
        this.runTest(bitContext, connection, expected, "functions/string/testLower.json");
    }

    @Test
    public void testPosition(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{new Long(2L), new Long(0L), new Long(0L), new Long(0L), new Long(2L), new Long(0L), new Long(0L), new Long(0L)};
        this.runTest(bitContext, connection, expected, "functions/string/testPosition.json");
    }

    @Test
    public void testRight(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{"ef", "abcdef", "abcdef", "cdef", "f", "", ""};
        this.runTest(bitContext, connection, expected, "functions/string/testRight.json");
    }

    @Test
    public void testSubstr(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{"abc", "bcd", "bcdef", "bcdef", "", "", "", "", "\u092d\u093e\u0930\u0924", "\u0935\u0930\u094d\u0937", "\u0935\u0930\u094d\u0937", "cdef", "", "", "", "\u0921\u094d\u0930\u093f\u0932"};
        this.runTest(bitContext, connection, expected, "functions/string/testSubstr.json");
    }

    @Test
    public void testLeft(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{"ab", "abcdef", "abcdef", "abcd", "a", "", ""};
        this.runTest(bitContext, connection, expected, "functions/string/testLeft.json");
    }

    @Test
    public void testLpad(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{"", "", "abcdef", "ab", "ab", "abcdef", "AAAAabcdef", "ABABabcdef", "ABCAabcdef", "ABCDabcdef"};
        this.runTest(bitContext, connection, expected, "functions/string/testLpad.json");
    }

    @Test
    public void testRegexpReplace(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{"ThM", "Th", "Thomas"};
        this.runTest(bitContext, connection, expected, "functions/string/testRegexpReplace.json");
    }

    @Test
    public void testRpad(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{"", "", "abcdef", "ab", "ab", "abcdef", "abcdefAAAA", "abcdefABAB", "abcdefABCA", "abcdefABCD"};
        this.runTest(bitContext, connection, expected, "functions/string/testRpad.json");
    }

    @Test
    public void testUpper(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{"ABCEFGH", "ABC", ""};
        this.runTest(bitContext, connection, expected, "functions/string/testUpper.json");
    }

    @Test
    public void testNewStringFuncs(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{97, 65, -32, "A", "btrim", "Peace Peace Peace ", "\u0939\u0915\u0941\u0928\u093e \u092e\u0924\u093e\u0924\u093e \u0939\u0915\u0941\u0928\u093e \u092e\u0924\u093e\u0924\u093e ", "katcit", "\u00c3\u00a2pple", "\u0928\u0926\u092e"};
        this.runTest(bitContext, connection, expected, "functions/string/testStringFuncs.json");
    }
}

