/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.sun.codemodel.JClassAlreadyExistsException;
import io.netty.buffer.DrillBuf;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import mockit.Injectable;
import mockit.NonStrictExpectations;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.TypedNullConstant;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.compile.CodeCompiler;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import org.apache.drill.exec.physical.impl.SimpleRootExec;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.resolver.FunctionResolver;
import org.apache.drill.exec.resolver.FunctionResolverFactory;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.junit.Assert;
import org.junit.Test;

public class TestSimpleFunctions
extends ExecTest {
    private final DrillConfig c = DrillConfig.create();

    @Test
    public void testHashFunctionResolution(@Injectable DrillConfig config) throws JClassAlreadyExistsException, IOException {
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(config);
        this.resolveHash(config, (LogicalExpression)new TypedNullConstant(Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.INT)), Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.INT), Types.required((TypeProtos.MinorType)TypeProtos.MinorType.INT), TypeProtos.DataMode.OPTIONAL, registry);
        this.resolveHash(config, (LogicalExpression)new ValueExpressions.IntExpression(1, ExpressionPosition.UNKNOWN), Types.required((TypeProtos.MinorType)TypeProtos.MinorType.INT), Types.required((TypeProtos.MinorType)TypeProtos.MinorType.INT), TypeProtos.DataMode.REQUIRED, registry);
        this.resolveHash(config, (LogicalExpression)new TypedNullConstant(Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.FLOAT4)), Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.FLOAT4), Types.required((TypeProtos.MinorType)TypeProtos.MinorType.FLOAT4), TypeProtos.DataMode.OPTIONAL, registry);
        this.resolveHash(config, (LogicalExpression)new ValueExpressions.FloatExpression(5.0f, ExpressionPosition.UNKNOWN), Types.required((TypeProtos.MinorType)TypeProtos.MinorType.FLOAT4), Types.required((TypeProtos.MinorType)TypeProtos.MinorType.FLOAT4), TypeProtos.DataMode.REQUIRED, registry);
        this.resolveHash(config, (LogicalExpression)new TypedNullConstant(Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.BIGINT)), Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.BIGINT), Types.required((TypeProtos.MinorType)TypeProtos.MinorType.BIGINT), TypeProtos.DataMode.OPTIONAL, registry);
        this.resolveHash(config, (LogicalExpression)new ValueExpressions.LongExpression(100L, ExpressionPosition.UNKNOWN), Types.required((TypeProtos.MinorType)TypeProtos.MinorType.BIGINT), Types.required((TypeProtos.MinorType)TypeProtos.MinorType.BIGINT), TypeProtos.DataMode.REQUIRED, registry);
        this.resolveHash(config, (LogicalExpression)new TypedNullConstant(Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.FLOAT8)), Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.FLOAT8), Types.required((TypeProtos.MinorType)TypeProtos.MinorType.FLOAT8), TypeProtos.DataMode.OPTIONAL, registry);
        this.resolveHash(config, (LogicalExpression)new ValueExpressions.DoubleExpression(100.0, ExpressionPosition.UNKNOWN), Types.required((TypeProtos.MinorType)TypeProtos.MinorType.FLOAT8), Types.required((TypeProtos.MinorType)TypeProtos.MinorType.FLOAT8), TypeProtos.DataMode.REQUIRED, registry);
    }

    public void resolveHash(DrillConfig config, LogicalExpression arg, TypeProtos.MajorType expectedArg, TypeProtos.MajorType expectedOut, TypeProtos.DataMode expectedBestInputMode, FunctionImplementationRegistry registry) throws JClassAlreadyExistsException, IOException {
        ArrayList<LogicalExpression> args = new ArrayList<LogicalExpression>();
        args.add(arg);
        String[] registeredNames = new String[]{"hash"};
        FunctionCall call = new FunctionCall("hash", args, ExpressionPosition.UNKNOWN);
        FunctionResolver resolver = FunctionResolverFactory.getResolver((FunctionCall)call);
        DrillFuncHolder matchedFuncHolder = registry.findDrillFunction(resolver, call);
        Assert.assertEquals((Object)expectedBestInputMode, (Object)matchedFuncHolder.getParmMajorType(0).getMode());
    }

    @Test
    public void testSubstring(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestSimpleFunctions.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestSimpleFunctions.this.c);
                bitContext.getConfig();
                result = TestSimpleFunctions.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestSimpleFunctions.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/functions/testSubstring.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        while (exec.next()) {
            NullableVarCharVector c1 = (NullableVarCharVector)((Object)exec.getValueVectorById(new SchemaPath("col3", ExpressionPosition.UNKNOWN), NullableVarCharVector.class));
            NullableVarCharVector.Accessor a1 = c1.getAccessor();
            int count = 0;
            for (int i = 0; i < c1.getAccessor().getValueCount(); ++i) {
                if (a1.isNull(i)) continue;
                NullableVarCharHolder holder = new NullableVarCharHolder();
                a1.get(i, holder);
                Assert.assertEquals((Object)"aaaa", (Object)StringFunctionHelpers.toStringFromUTF8((int)holder.start, (int)holder.end, (DrillBuf)holder.buffer));
                ++count;
            }
            Assert.assertEquals((long)50L, (long)count);
        }
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void testSubstringNegative(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestSimpleFunctions.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestSimpleFunctions.this.c);
                bitContext.getConfig();
                result = TestSimpleFunctions.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestSimpleFunctions.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/functions/testSubstringNegative.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        while (exec.next()) {
            NullableVarCharVector c1 = (NullableVarCharVector)((Object)exec.getValueVectorById(new SchemaPath("col3", ExpressionPosition.UNKNOWN), NullableVarCharVector.class));
            NullableVarCharVector.Accessor a1 = c1.getAccessor();
            int count = 0;
            for (int i = 0; i < c1.getAccessor().getValueCount(); ++i) {
                if (a1.isNull(i)) continue;
                NullableVarCharHolder holder = new NullableVarCharHolder();
                a1.get(i, holder);
                Assert.assertEquals((Object)"", (Object)StringFunctionHelpers.toStringFromUTF8((int)holder.start, (int)holder.end, (DrillBuf)holder.buffer));
                ++count;
            }
            Assert.assertEquals((long)50L, (long)count);
        }
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void testByteSubstring(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestSimpleFunctions.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestSimpleFunctions.this.c);
                bitContext.getConfig();
                result = TestSimpleFunctions.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestSimpleFunctions.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/functions/testByteSubstring.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        while (exec.next()) {
            NullableVarBinaryVector c1 = (NullableVarBinaryVector)((Object)exec.getValueVectorById(new SchemaPath("col3", ExpressionPosition.UNKNOWN), NullableVarBinaryVector.class));
            NullableVarBinaryVector.Accessor a1 = c1.getAccessor();
            int count = 0;
            for (int i = 0; i < c1.getAccessor().getValueCount(); ++i) {
                if (a1.isNull(i)) continue;
                NullableVarBinaryHolder holder = new NullableVarBinaryHolder();
                a1.get(i, holder);
                Assert.assertEquals((Object)"aa", (Object)StringFunctionHelpers.toStringFromUTF8((int)holder.start, (int)holder.end, (DrillBuf)holder.buffer));
                ++count;
            }
            Assert.assertEquals((long)50L, (long)count);
        }
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }
}

