/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSimpleFragmentRun
extends PopUnitTestBase {
    private static final Logger logger = LoggerFactory.getLogger(TestSimpleFragmentRun.class);

    @Test
    public void runNoExchangeFragment() throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            String path = "/physical_test2.json";
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/physical_test2.json"), (Charset)Charsets.UTF_8));
            RecordBatchLoader batchLoader = new RecordBatchLoader(client.getAllocator());
            int recordCount = 0;
            for (QueryDataBatch batch : results) {
                boolean schemaChanged = batchLoader.load(batch.getHeader().getDef(), batch.getData());
                boolean firstColumn = true;
                if (schemaChanged) {
                    System.out.println("\n\n========NEW SCHEMA=========\n\n");
                    for (VectorWrapper value : batchLoader) {
                        if (firstColumn) {
                            firstColumn = false;
                        } else {
                            System.out.print("\t");
                        }
                        System.out.print(value.getField().toExpr());
                        System.out.print("[");
                        System.out.print(value.getField().getType().getMinorType());
                        System.out.print("]");
                    }
                    System.out.println();
                }
                for (int i = 0; i < batchLoader.getRecordCount(); ++i) {
                    boolean first = true;
                    ++recordCount;
                    for (VectorWrapper value : batchLoader) {
                        if (first) {
                            first = false;
                        } else {
                            System.out.print("\t");
                        }
                        System.out.print(value.getValueVector().getAccessor().getObject(i));
                    }
                    if (first) continue;
                    System.out.println();
                }
                batchLoader.clear();
                batch.release();
            }
            logger.debug("Received results {}", (Object)results);
            Assert.assertEquals((long)recordCount, (long)200L);
        }
    }

    @Test
    public void runJSONScanPopFragment() throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/physical_json_scan_test1.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", FileUtils.getResourceAsFile((String)"/scan_json_test_1.json").toURI().toString()));
            RecordBatchLoader batchLoader = new RecordBatchLoader(RootAllocatorFactory.newRoot((DrillConfig)CONFIG));
            int recordCount = 0;
            for (int i = 0; i < results.size(); ++i) {
                QueryDataBatch batch = (QueryDataBatch)results.get(i);
                if (i != 0) {
                    Assert.assertFalse((boolean)batch.hasData());
                    batch.release();
                    continue;
                }
                Assert.assertTrue((boolean)batch.hasData());
                Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
                boolean firstColumn = true;
                System.out.println("\n\n========NEW SCHEMA=========\n\n");
                for (VectorWrapper v : batchLoader) {
                    if (firstColumn) {
                        firstColumn = false;
                    } else {
                        System.out.print("\t");
                    }
                    System.out.print(v.getField().toExpr());
                    System.out.print("[");
                    System.out.print(v.getField().getType().getMinorType());
                    System.out.print("]");
                }
                System.out.println();
                for (int r = 0; r < batchLoader.getRecordCount(); ++r) {
                    boolean first = true;
                    ++recordCount;
                    for (VectorWrapper v : batchLoader) {
                        if (first) {
                            first = false;
                        } else {
                            System.out.print("\t");
                        }
                        ValueVector.Accessor accessor = v.getValueVector().getAccessor();
                        System.out.print(accessor.getObject(r));
                    }
                    if (first) continue;
                    System.out.println();
                }
                batchLoader.clear();
                batch.release();
            }
            Assert.assertEquals((long)2L, (long)recordCount);
        }
    }
}

