/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import mockit.Injectable;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Assert;
import org.junit.Test;

public class TestReverseImplicitCast
extends PopUnitTestBase {
    @Test
    public void twoWayCast(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/functions/cast/two_way_implicit_cast.json"), (Charset)Charsets.UTF_8));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(0);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            Iterator itr = batchLoader.iterator();
            ValueVector.Accessor intAccessor1 = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            ValueVector.Accessor varcharAccessor1 = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            for (int i = 0; i < intAccessor1.getValueCount(); ++i) {
                System.out.println(intAccessor1.getObject(i));
                Assert.assertEquals((Object)intAccessor1.getObject(i), (Object)10);
                System.out.println(varcharAccessor1.getObject(i));
                Assert.assertEquals((Object)varcharAccessor1.getObject(i).toString(), (Object)"101");
            }
            batchLoader.clear();
            for (QueryDataBatch result : results) {
                result.release();
            }
        }
    }
}

