/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import mockit.Injectable;
import mockit.NonStrictExpectations;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.opt.BasicOptimizer;
import org.apache.drill.exec.opt.Optimizer;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.SimpleRootExec;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.control.Controller;
import org.apache.drill.exec.rpc.control.WorkEventBus;
import org.apache.drill.exec.rpc.data.DataConnectionCreator;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.BootStrapContext;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.apache.drill.exec.store.sys.local.LocalPStoreProvider;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarBinaryVector;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TestOptiqPlans
extends ExecTest {
    private final DrillConfig config = DrillConfig.create();

    @Test
    public void orderBy(@Injectable BootStrapContext ctxt, @Injectable UserServer.UserClientConnection connection, @Injectable ClusterCoordinator coord, @Injectable DataConnectionCreator com, @Injectable Controller controller, @Injectable WorkEventBus workBus) throws Throwable {
        SimpleRootExec exec = this.doLogicalTest(ctxt, connection, "/logical_order.json", coord, com, controller, workBus);
    }

    @Test
    public void stringFilter(@Injectable BootStrapContext ctxt, @Injectable UserServer.UserClientConnection connection, @Injectable ClusterCoordinator coord, @Injectable DataConnectionCreator com, @Injectable Controller controller, @Injectable WorkEventBus workBus) throws Throwable {
        SimpleRootExec exec = this.doLogicalTest(ctxt, connection, "/logical_string_filter.json", coord, com, controller, workBus);
    }

    @Test
    public void groupBy(@Injectable BootStrapContext bitContext, @Injectable UserServer.UserClientConnection connection, @Injectable ClusterCoordinator coord, @Injectable DataConnectionCreator com, @Injectable Controller controller, @Injectable WorkEventBus workBus) throws Throwable {
        SimpleRootExec exec = this.doLogicalTest(bitContext, connection, "/logical_group.json", coord, com, controller, workBus);
    }

    private SimpleRootExec doLogicalTest(final BootStrapContext context, UserServer.UserClientConnection connection, String file, ClusterCoordinator coord, DataConnectionCreator com, Controller controller, WorkEventBus workBus) throws Exception {
        new NonStrictExpectations(){
            {
                context.getMetrics();
                result = new MetricRegistry();
                context.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestOptiqPlans.this.config);
                context.getConfig();
                result = TestOptiqPlans.this.config;
            }
        };
        RemoteServiceSet lss = RemoteServiceSet.getLocalServiceSet();
        DrillbitContext bitContext = new DrillbitContext(CoordinationProtos.DrillbitEndpoint.getDefaultInstance(), context, coord, controller, com, workBus, (PStoreProvider)new LocalPStoreProvider(this.config), null);
        QueryContext qc = new QueryContext(UserSession.Builder.newBuilder().setSupportComplexTypes(true).build(), bitContext);
        PhysicalPlanReader reader = bitContext.getPlanReader();
        LogicalPlan plan = reader.readLogicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)file), (Charset)Charsets.UTF_8));
        PhysicalPlan pp = new BasicOptimizer(qc, connection).optimize((Optimizer.OptimizationContext)new BasicOptimizer.BasicOptimizationContext(qc), plan);
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.config);
        FragmentContext fctxt = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)fctxt, (FragmentRoot)((FragmentRoot)pp.getSortedOperators(false).iterator().next())));
        return exec;
    }

    @Test
    public void testFilterPlan() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(this.config, serviceSet);
             DrillClient client = new DrillClient(this.config, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Resources.toString((URL)Resources.getResource((String)"physical_filter.json"), (Charset)Charsets.UTF_8));
            RecordBatchLoader loader = new RecordBatchLoader(bit1.getContext().getAllocator());
            for (QueryDataBatch b : results) {
                System.out.println(String.format("Got %d results", b.getHeader().getRowCount()));
                loader.load(b.getHeader().getDef(), b.getData());
                for (VectorWrapper vw : loader) {
                    System.out.println(vw.getValueVector().getField().toExpr());
                    ValueVector vv = vw.getValueVector();
                    for (int i = 0; i < vv.getAccessor().getValueCount(); ++i) {
                        Object o = vv.getAccessor().getObject(i);
                        System.out.println(vv.getAccessor().getObject(i));
                    }
                }
                loader.clear();
                b.release();
            }
            client.close();
        }
    }

    @Test
    public void testJoinPlan() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(this.config, serviceSet);
             DrillClient client = new DrillClient(this.config, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Resources.toString((URL)Resources.getResource((String)"physical_join.json"), (Charset)Charsets.UTF_8));
            RecordBatchLoader loader = new RecordBatchLoader(bit1.getContext().getAllocator());
            for (QueryDataBatch b : results) {
                System.out.println(String.format("Got %d results", b.getHeader().getRowCount()));
                loader.load(b.getHeader().getDef(), b.getData());
                for (VectorWrapper vw : loader) {
                    System.out.println(vw.getValueVector().getField().toExpr());
                    ValueVector vv = vw.getValueVector();
                    for (int i = 0; i < vv.getAccessor().getValueCount(); ++i) {
                        Object o = vv.getAccessor().getObject(i);
                        System.out.println(vv.getAccessor().getObject(i));
                    }
                }
                loader.clear();
                b.release();
            }
            client.close();
        }
    }

    @Test
    public void testFilterString() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(this.config, serviceSet);
             DrillClient client = new DrillClient(this.config, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.LOGICAL, Resources.toString((URL)Resources.getResource((String)"logical_string_filter.json"), (Charset)Charsets.UTF_8));
            RecordBatchLoader loader = new RecordBatchLoader(bit1.getContext().getAllocator());
            for (QueryDataBatch b : results) {
                System.out.println(String.format("Got %d results", b.getHeader().getRowCount()));
                loader.load(b.getHeader().getDef(), b.getData());
                for (VectorWrapper vw : loader) {
                    System.out.println(vw.getValueVector().getField().toExpr());
                    ValueVector vv = vw.getValueVector();
                    for (int i = 0; i < vv.getAccessor().getValueCount(); ++i) {
                        Object o = vv.getAccessor().getObject(i);
                        if (vv instanceof VarBinaryVector) {
                            VarBinaryVector.Accessor x = ((VarBinaryVector)vv).getAccessor();
                            VarBinaryHolder vbh = new VarBinaryHolder();
                            x.get(i, vbh);
                            System.out.printf("%d..%d", vbh.start, vbh.end);
                            System.out.println("[" + new String((byte[])vv.getAccessor().getObject(i)) + "]");
                            continue;
                        }
                        System.out.println(vv.getAccessor().getObject(i));
                    }
                }
                loader.clear();
                b.release();
            }
            client.close();
        }
    }

    @Test
    public void testLogicalJsonScan() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(this.config, serviceSet);
             DrillClient client = new DrillClient(this.config, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.LOGICAL, Resources.toString((URL)Resources.getResource((String)"logical_json_scan.json"), (Charset)Charsets.UTF_8));
            RecordBatchLoader loader = new RecordBatchLoader(bit1.getContext().getAllocator());
            for (QueryDataBatch b : results) {
                System.out.println(String.format("Got %d results", b.getHeader().getRowCount()));
                loader.load(b.getHeader().getDef(), b.getData());
                for (VectorWrapper vw : loader) {
                    System.out.println(vw.getValueVector().getField().toExpr());
                    ValueVector vv = vw.getValueVector();
                    for (int i = 0; i < vv.getAccessor().getValueCount(); ++i) {
                        Object o = vv.getAccessor().getObject(i);
                        if (vv instanceof VarBinaryVector) {
                            VarBinaryVector.Accessor x = ((VarBinaryVector)vv).getAccessor();
                            VarBinaryHolder vbh = new VarBinaryHolder();
                            x.get(i, vbh);
                            System.out.printf("%d..%d", vbh.start, vbh.end);
                            System.out.println("[" + new String((byte[])vv.getAccessor().getObject(i)) + "]");
                            continue;
                        }
                        System.out.println(vv.getAccessor().getObject(i));
                    }
                }
                loader.clear();
                b.release();
            }
            client.close();
        }
    }

    @Test
    public void testOrderVarbinary() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(this.config, serviceSet);
             DrillClient client = new DrillClient(this.config, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Resources.toString((URL)Resources.getResource((String)"physical_order_varbinary.json"), (Charset)Charsets.UTF_8));
            RecordBatchLoader loader = new RecordBatchLoader(bit1.getContext().getAllocator());
            for (QueryDataBatch b : results) {
                System.out.println(String.format("Got %d results", b.getHeader().getRowCount()));
                loader.load(b.getHeader().getDef(), b.getData());
                for (VectorWrapper vw : loader) {
                    System.out.println(vw.getValueVector().getField().toExpr());
                    ValueVector vv = vw.getValueVector();
                    for (int i = 0; i < vv.getAccessor().getValueCount(); ++i) {
                        Object o = vv.getAccessor().getObject(i);
                        if (vv instanceof VarBinaryVector) {
                            VarBinaryVector.Accessor x = ((VarBinaryVector)vv).getAccessor();
                            VarBinaryHolder vbh = new VarBinaryHolder();
                            x.get(i, vbh);
                            System.out.printf("%d..%d", vbh.start, vbh.end);
                            System.out.println("[" + new String((byte[])vv.getAccessor().getObject(i)) + "]");
                            continue;
                        }
                        System.out.println(vv.getAccessor().getObject(i));
                    }
                }
                loader.clear();
                b.release();
            }
            client.close();
        }
    }

    private SimpleRootExec doPhysicalTest(final DrillbitContext bitContext, UserServer.UserClientConnection connection, String file) throws Exception {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestOptiqPlans.this.config);
                bitContext.getConfig();
                result = TestOptiqPlans.this.config;
            }
        };
        StoragePluginRegistry reg = new StoragePluginRegistry(bitContext);
        PhysicalPlanReader reader = new PhysicalPlanReader(this.config, this.config.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance(), reg);
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)file), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.config);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        return exec;
    }
}

