/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import mockit.Injectable;
import mockit.NonStrictExpectations;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.compile.CodeCompiler;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import org.apache.drill.exec.physical.impl.SimpleRootExec;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Assert;
import org.junit.Test;

public class TestImplicitCastFunctions
extends ExecTest {
    private final DrillConfig c = DrillConfig.create();
    private PhysicalPlanReader reader;
    private FunctionImplementationRegistry registry;
    private FragmentContext context;

    public Object[] getRunResult(SimpleRootExec exec) {
        int size = 0;
        for (ValueVector v : exec) {
            ++size;
        }
        Object[] res = new Object[size];
        int i = 0;
        for (ValueVector v : exec) {
            res[i++] = v.getAccessor().getObject(0);
        }
        return res;
    }

    public void runTest(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection, Object[] expectedResults, String planPath) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestImplicitCastFunctions.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestImplicitCastFunctions.this.c);
                bitContext.getConfig();
                result = TestImplicitCastFunctions.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestImplicitCastFunctions.this.c);
            }
        };
        String planString = Resources.toString((URL)Resources.getResource((String)planPath), (Charset)Charsets.UTF_8);
        if (this.reader == null) {
            this.reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        }
        if (this.registry == null) {
            this.registry = new FunctionImplementationRegistry(this.c);
        }
        if (this.context == null) {
            this.context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, this.registry);
        }
        PhysicalPlan plan = this.reader.readPhysicalPlan(planString);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)this.context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        exec.next();
        while (exec.next()) {
            Object[] res = this.getRunResult(exec);
            Assert.assertEquals((String)"return count does not match", (long)res.length, (long)expectedResults.length);
            for (int i = 0; i < res.length; ++i) {
                Assert.assertEquals((String)String.format("column %s does not match", i), (Object)res[i], (Object)expectedResults[i]);
            }
        }
        if (this.context.getFailureCause() != null) {
            throw this.context.getFailureCause();
        }
        Assert.assertTrue((!this.context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void testImplicitCastWithConstant(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{new Double(30.1), new Double(30.1), new Double(30.1), new Double(30.1), new Long(30L), new Long(30L), new Double(30.1), new Double(30.1), new Float(30.1), new Float(30.1), new Double(30.1), new Double(30.1), new Float(30.1), new Double(30.1), new Float(30.1), new Double(30.1), Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
        this.runTest(bitContext, connection, expected, "functions/cast/testICastConstant.json");
    }

    @Test
    public void testImplicitCastWithMockColumn(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{new Integer(0), new Integer(0), new Float(-2.14748365E9), new Float(-2.14748365E9), new Double(-9.223372036854776E18)};
        this.runTest(bitContext, connection, expected, "functions/cast/testICastMockCol.json");
    }

    @Test
    public void testImplicitCastWithNullExpression(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, null, null, null, null, null, null};
        this.runTest(bitContext, connection, expected, "functions/cast/testICastNullExp.json");
    }
}

