/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExtractFunctions
extends PopUnitTestBase {
    static final Logger logger = LoggerFactory.getLogger(TestExtractFunctions.class);

    @Test
    public void testFromDate() throws Exception {
        long[][] expectedValues = new long[][]{{0L, 0L, 2L, 1L, 1970L}, {0L, 0L, 28L, 12L, 2008L}, {0L, 0L, 27L, 2L, 2000L}};
        this.testFrom("date", "/test_simple_date.json", "stringdate", expectedValues);
    }

    @Test
    @Ignore
    public void testFromTime() throws Exception {
        long[][] expectedValues = new long[][]{{20L, 10L, 0L, 0L, 0L}, {34L, 11L, 0L, 0L, 0L}, {24L, 14L, 0L, 0L, 0L}};
        this.testFrom("time", "/test_simple_time.json", "stringtime", expectedValues);
    }

    @Test
    public void testFromTimeStamp() throws Exception {
        long[][] expectedValues = new long[][]{{20L, 10L, 2L, 1L, 1970L}, {34L, 11L, 28L, 12L, 2008L}, {24L, 14L, 27L, 2L, 2000L}};
        this.testFrom("timestamp", "/test_simple_date.json", "stringdate", expectedValues);
    }

    @Test
    public void testFromInterval() throws Exception {
        long[][] expectedValues = new long[][]{{20L, 1L, 1L, 2L, 2L}, {0L, 0L, 0L, 2L, 2L}, {20L, 1L, 0L, 0L, 0L}, {20L, 1L, 1L, 2L, 2L}, {0L, 0L, 0L, 0L, 0L}, {-39L, 0L, 1L, 10L, 1L}};
        this.testFrom("interval", "/test_simple_interval.json", "stringinterval", expectedValues);
    }

    @Test
    public void testFromIntervalDay() throws Exception {
        long[][] expectedValues = new long[][]{{20L, 1L, 1L, 0L, 0L}, {0L, 0L, 0L, 0L, 0L}, {20L, 1L, 0L, 0L, 0L}, {20L, 1L, 1L, 0L, 0L}, {0L, 0L, 0L, 0L, 0L}, {-39L, 0L, 1L, 0L, 0L}};
        this.testFrom("intervalday", "/test_simple_interval.json", "stringinterval", expectedValues);
    }

    @Test
    public void testFromIntervalYear() throws Exception {
        long[][] expectedValues = new long[][]{{0L, 0L, 0L, 2L, 2L}, {0L, 0L, 0L, 2L, 2L}, {0L, 0L, 0L, 0L, 0L}, {0L, 0L, 0L, 2L, 2L}, {0L, 0L, 0L, 0L, 0L}, {0L, 0L, 0L, 10L, 1L}};
        this.testFrom("intervalyear", "/test_simple_interval.json", "stringinterval", expectedValues);
    }

    private void testFrom(String fromType, String testDataFile, String columnName, long[][] expectedValues) throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/functions/extractFrom.json"), (Charset)Charsets.UTF_8).replace("#{TEST_TYPE}", fromType).replace("#{TEST_FILE}", testDataFile).replace("#{COLUMN_NAME}", columnName));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(0);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            for (int i = 0; i < expectedValues.length; ++i) {
                for (int j = 0; j < expectedValues[i].length; ++j) {
                    NullableBigIntVector vv = (NullableBigIntVector)batchLoader.getValueAccessorById(NullableBigIntVector.class, new int[]{j}).getValueVector();
                    System.out.println("[" + i + "][" + j + "]: Expected: " + expectedValues[i][j] + ", Actual: " + vv.getAccessor().get(i));
                    Assert.assertEquals((long)expectedValues[i][j], (long)vv.getAccessor().get(i));
                }
            }
            for (QueryDataBatch b : results) {
                b.release();
            }
            batchLoader.clear();
        }
    }
}

