/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDistributedFragmentRun
extends PopUnitTestBase {
    static final Logger logger = LoggerFactory.getLogger(TestDistributedFragmentRun.class);

    @Test
    public void oneBitOneExchangeOneEntryRun() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/physical_single_exchange.json"), (Charset)Charsets.UTF_8));
            int count = 0;
            for (QueryDataBatch b : results) {
                count += b.getHeader().getRowCount();
                b.release();
            }
            Assert.assertEquals((long)100L, (long)count);
        }
    }

    @Test
    public void oneBitOneExchangeTwoEntryRun() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/physical_single_exchange_double_entry.json"), (Charset)Charsets.UTF_8));
            int count = 0;
            for (QueryDataBatch b : results) {
                count += b.getHeader().getRowCount();
                b.release();
            }
            Assert.assertEquals((long)200L, (long)count);
        }
    }

    @Test
    public void oneBitOneExchangeTwoEntryRunLogical() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.LOGICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/scan_screen_logical.json"), (Charset)Charsets.UTF_8));
            int count = 0;
            for (QueryDataBatch b : results) {
                count += b.getHeader().getRowCount();
                b.release();
            }
            Assert.assertEquals((long)100L, (long)count);
        }
    }

    @Test
    public void twoBitOneExchangeTwoEntryRun() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             Drillbit bit2 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            bit2.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/physical_single_exchange_double_entry.json"), (Charset)Charsets.UTF_8));
            int count = 0;
            for (QueryDataBatch b : results) {
                count += b.getHeader().getRowCount();
                b.release();
            }
            Assert.assertEquals((long)200L, (long)count);
        }
    }
}

