/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Assert;
import org.junit.Test;

public class TestDecimal
extends PopUnitTestBase {
    DrillConfig c = DrillConfig.create();

    @Test
    public void testSimpleDecimal() throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/decimal/cast_simple_decimal.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", "/input_simple_decimal.json"));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(0);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            String[] decimal9Output = new String[]{"99.0000", "11.1235", "0.1000", "-0.1200", "-123.1234", "-1.0001"};
            String[] decimal18Output = new String[]{"123456789.000000000", "11.123456789", "0.100000000", "-0.100400000", "-987654321.123456789", "-2.030100000"};
            Iterator itr = batchLoader.iterator();
            ValueVector.Accessor dec9Accessor = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            ValueVector.Accessor dec18Accessor = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            for (int i = 0; i < dec9Accessor.getValueCount(); ++i) {
                Assert.assertEquals((Object)dec9Accessor.getObject(i).toString(), (Object)decimal9Output[i]);
                Assert.assertEquals((Object)dec18Accessor.getObject(i).toString(), (Object)decimal18Output[i]);
            }
            Assert.assertEquals((long)6L, (long)dec9Accessor.getValueCount());
            Assert.assertEquals((long)6L, (long)dec18Accessor.getValueCount());
            batchLoader.clear();
            for (QueryDataBatch result : results) {
                result.release();
            }
        }
    }

    @Test
    public void testCastFromFloat() throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/decimal/cast_float_decimal.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", "/input_simple_decimal.json"));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(0);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            String[] decimal9Output = new String[]{"99.0000", "11.1235", "0.1000", "-0.1200", "-123.1234", "-1.0001"};
            String[] decimal38Output = new String[]{"123456789.0000", "11.1235", "0.1000", "-0.1004", "-987654321.1235", "-2.0301"};
            Iterator itr = batchLoader.iterator();
            ValueVector.Accessor dec9Accessor = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            ValueVector.Accessor dec38Accessor = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            for (int i = 0; i < dec9Accessor.getValueCount(); ++i) {
                Assert.assertEquals((Object)dec9Accessor.getObject(i).toString(), (Object)decimal9Output[i]);
                Assert.assertEquals((Object)dec38Accessor.getObject(i).toString(), (Object)decimal38Output[i]);
            }
            Assert.assertEquals((long)6L, (long)dec9Accessor.getValueCount());
            Assert.assertEquals((long)6L, (long)dec38Accessor.getValueCount());
            batchLoader.clear();
            for (QueryDataBatch result : results) {
                result.release();
            }
        }
    }

    @Test
    public void testSimpleDecimalArithmetic() throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/decimal/simple_decimal_arithmetic.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", "/input_simple_decimal.json"));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(0);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            String[] addOutput = new String[]{"123456888.0", "22.2", "0.2", "-0.2", "-987654444.2", "-3.0"};
            String[] subtractOutput = new String[]{"123456690.0", "0.0", "0.0", "0.0", "-987654198.0", "-1.0"};
            String[] multiplyOutput = new String[]{"12222222111.00", "123.21", "0.01", "0.01", "121580246927.41", "2.00"};
            Iterator itr = batchLoader.iterator();
            ValueVector.Accessor addAccessor = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            ValueVector.Accessor subAccessor = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            ValueVector.Accessor mulAccessor = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            for (int i = 0; i < addAccessor.getValueCount(); ++i) {
                Assert.assertEquals((Object)addAccessor.getObject(i).toString(), (Object)addOutput[i]);
                Assert.assertEquals((Object)subAccessor.getObject(i).toString(), (Object)subtractOutput[i]);
                Assert.assertEquals((Object)mulAccessor.getObject(i).toString(), (Object)multiplyOutput[i]);
            }
            Assert.assertEquals((long)6L, (long)addAccessor.getValueCount());
            Assert.assertEquals((long)6L, (long)subAccessor.getValueCount());
            Assert.assertEquals((long)6L, (long)mulAccessor.getValueCount());
            batchLoader.clear();
            for (QueryDataBatch result : results) {
                result.release();
            }
        }
    }

    @Test
    public void testComplexDecimal() throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/decimal/test_decimal_complex.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", "/input_complex_decimal.json"));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(0);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            String[] addOutput = new String[]{"-99999998877.700000000", "11.423456789", "123456789.100000000", "-0.119998000", "100000000112.423456789", "-99999999879.907000000", "123456789123456801.300000000"};
            String[] subtractOutput = new String[]{"-100000001124.300000000", "10.823456789", "-123456788.900000000", "-0.120002000", "99999999889.823456789", "-100000000122.093000000", "123456789123456776.700000000"};
            Iterator itr = batchLoader.iterator();
            ValueVector.Accessor addAccessor = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            ValueVector.Accessor subAccessor = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            for (int i = 0; i < addAccessor.getValueCount(); ++i) {
                Assert.assertEquals((Object)addAccessor.getObject(i).toString(), (Object)addOutput[i]);
                Assert.assertEquals((Object)subAccessor.getObject(i).toString(), (Object)subtractOutput[i]);
            }
            Assert.assertEquals((long)7L, (long)addAccessor.getValueCount());
            Assert.assertEquals((long)7L, (long)subAccessor.getValueCount());
            batchLoader.clear();
            for (QueryDataBatch result : results) {
                result.release();
            }
        }
    }

    @Test
    public void testComplexDecimalSort() throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/decimal/test_decimal_sort_complex.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", "/input_sort_complex_decimal.json"));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(1);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            String[] sortOutput = new String[]{"-100000000001.000000000000", "-100000000001.000000000000", "-145456789.120123000000", "-0.120000000000", "0.100000000001", "11.123456789012", "1278789.100000000000", "145456789.120123000000", "100000000001.123456789001", "123456789123456789.000000000000"};
            Iterator itr = batchLoader.iterator();
            VectorWrapper v = (VectorWrapper)itr.next();
            ValueVector.Accessor accessor = v.getValueVector().getAccessor();
            for (int i = 0; i < accessor.getValueCount(); ++i) {
                Assert.assertEquals((Object)sortOutput[i], (Object)accessor.getObject(i).toString());
            }
            Assert.assertEquals((long)10L, (long)accessor.getValueCount());
            batchLoader.clear();
            for (QueryDataBatch result : results) {
                result.release();
            }
        }
    }

    @Test
    public void testSimpleDecimalMathFunc() throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/decimal/simple_decimal_math.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", "/input_simple_decimal.json"));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(0);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            Iterator itr = batchLoader.iterator();
            ValueVector.Accessor dec18Accessor = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            Assert.assertEquals((long)6L, (long)dec18Accessor.getValueCount());
            batchLoader.clear();
            for (QueryDataBatch result : results) {
                result.release();
            }
        }
    }
}

