/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import io.netty.buffer.DrillBuf;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import mockit.Injectable;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.TestBuilder;
import org.apache.drill.exec.compile.ClassTransformer;
import org.apache.drill.exec.expr.fn.impl.DateUtility;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.server.options.SystemOptionManager;
import org.apache.drill.exec.util.ByteBufUtil;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.util.JsonStringHashMap;
import org.apache.drill.exec.util.VectorUtil;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestConvertFunctions
extends BaseTestQuery {
    private static final String CONVERSION_TEST_LOGICAL_PLAN = "functions/conv/conversionTestWithLogicalPlan.json";
    private static final String CONVERSION_TEST_PHYSICAL_PLAN = "functions/conv/conversionTestWithPhysicalPlan.json";
    private static final float DELTA = 1.0E-4f;
    private static final String DATE_TIME_BE = "\\x00\\x00\\x00\\x49\\x77\\x85\\x1f\\x8e";
    private static final String DATE_TIME_LE = "\\x8e\\x1f\\x85\\x77\\x49\\x00\\x00\\x00";
    private static DateTime time = DateTime.parse((String)"01:23:45.678", (DateTimeFormatter)DateUtility.getTimeFormatter());
    private static DateTime date = DateTime.parse((String)"1980-01-01", (DateTimeFormatter)DateUtility.getDateTimeFormatter());
    String textFileContent;

    @Test
    public void test_JSON_convertTo_empty_list_drill_1416() throws Exception {
        String listStr = "[ 4, 6 ]";
        TestConvertFunctions.testBuilder().sqlQuery("select cast(convert_to(rl[1], 'JSON') as varchar(100)) as json_str from cp.`/store/json/input2.json`").unOrdered().baselineColumns("json_str").baselineValues(listStr).baselineValues("[ ]").baselineValues(listStr).baselineValues(listStr).go();
        JsonStringArrayList listVal = TestBuilder.listOf(4L, 6L);
        TestConvertFunctions.testBuilder().sqlQuery("select convert_from(convert_to(rl[1], 'JSON'), 'JSON') list_col from cp.`/store/json/input2.json`").unOrdered().baselineColumns("list_col").baselineValues(listVal).baselineValues(TestBuilder.listOf(new Object[0])).baselineValues(listVal).baselineValues(listVal).go();
        JsonStringHashMap<String, Object> mapVal1 = TestBuilder.mapOf("f1", 4L, "f2", 6L);
        JsonStringHashMap<String, Object> mapVal2 = TestBuilder.mapOf("f1", 11L);
        TestConvertFunctions.testBuilder().sqlQuery("select convert_from(convert_to(rl[1], 'JSON'), 'JSON') as map_col from cp.`/store/json/json_project_null_object_from_list.json`").unOrdered().baselineColumns("map_col").baselineValues(mapVal1).baselineValues(TestBuilder.mapOf(new Object[0])).baselineValues(mapVal2).baselineValues(mapVal1).go();
    }

    @Test
    public void testConvertToComplexJSON() throws Exception {
        String result1 = "[ {\n  \"$numberLong\" : 4\n}, {\n  \"$numberLong\" : 6\n} ]";
        String result2 = "[ ]";
        TestConvertFunctions.testBuilder().sqlQuery("select cast(convert_to(rl[1], 'EXTENDEDJSON') as varchar(100)) as json_str from cp.`/store/json/input2.json`").unOrdered().baselineColumns("json_str").baselineValues(result1).baselineValues(result2).baselineValues(result1).baselineValues(result1).go();
    }

    @Test
    public void testDateTime1() throws Throwable {
        this.verifyPhysicalPlan("(convert_from(binary_string('\\x00\\x00\\x00\\x49\\x77\\x85\\x1f\\x8e'), 'TIME_EPOCH_BE'))", time);
    }

    @Test
    public void testDateTime2() throws Throwable {
        this.verifyPhysicalPlan("convert_from(binary_string('\\x8e\\x1f\\x85\\x77\\x49\\x00\\x00\\x00'), 'TIME_EPOCH')", time);
    }

    @Test
    public void testDateTime3() throws Throwable {
        this.verifyPhysicalPlan("convert_from(binary_string('\\x00\\x00\\x00\\x49\\x77\\x85\\x1f\\x8e'), 'DATE_EPOCH_BE')", date);
    }

    @Test
    public void testDateTime4() throws Throwable {
        this.verifyPhysicalPlan("convert_from(binary_string('\\x8e\\x1f\\x85\\x77\\x49\\x00\\x00\\x00'), 'DATE_EPOCH')", date);
    }

    @Test
    public void testFixedInts1() throws Throwable {
        this.verifyPhysicalPlan("convert_from(binary_string('\\xAD'), 'TINYINT')", (byte)-83);
    }

    @Test
    public void testFixedInts2() throws Throwable {
        this.verifyPhysicalPlan("convert_from(binary_string('\\xFE\\xCA'), 'SMALLINT')", (short)-13570);
    }

    @Test
    public void testFixedInts3() throws Throwable {
        this.verifyPhysicalPlan("convert_from(binary_string('\\xCA\\xFE'), 'SMALLINT_BE')", (short)-13570);
    }

    @Test
    public void testFixedInts4() throws Throwable {
        this.verifyPhysicalPlan("convert_from(binary_string('\\xBE\\xBA\\xFE\\xCA'), 'INT')", -889275714);
    }

    @Test
    public void testFixedInts4SQL_from() throws Throwable {
        this.verifySQL("select   convert_from(binary_string('\\xBE\\xBA\\xFE\\xCA'), 'INT') from   cp.`employee.json` LIMIT 1", -889275714);
    }

    @Test
    public void testFixedInts4SQL_to() throws Throwable {
        this.verifySQL("select   convert_to(-889275714, 'INT') from   cp.`employee.json` LIMIT 1", new byte[]{-66, -70, -2, -54});
    }

    @Test
    public void testFixedInts5() throws Throwable {
        this.verifyPhysicalPlan("convert_from(binary_string('\\xCA\\xFE\\xBA\\xBE'), 'INT_BE')", -889275714);
    }

    @Test
    public void testFixedInts6() throws Throwable {
        this.verifyPhysicalPlan("convert_from(binary_string('\\xEF\\xBE\\xAD\\xDE\\xBE\\xBA\\xFE\\xCA'), 'BIGINT')", -3819410105021120785L);
    }

    @Test
    public void testFixedInts7() throws Throwable {
        this.verifyPhysicalPlan("convert_from(binary_string('\\xCA\\xFE\\xBA\\xBE\\xDE\\xAD\\xBE\\xEF'), 'BIGINT_BE')", -3819410105021120785L);
    }

    @Test
    public void testFixedInts8() throws Throwable {
        this.verifyPhysicalPlan("convert_from(convert_to(cast(77 as varchar(2)), 'INT_BE'), 'INT_BE')", 77);
    }

    @Test
    public void testFixedInts9() throws Throwable {
        this.verifyPhysicalPlan("convert_to(cast(77 as varchar(2)), 'INT_BE')", new byte[]{0, 0, 0, 77});
    }

    @Test
    public void testFixedInts10() throws Throwable {
        this.verifyPhysicalPlan("convert_to(cast(77 as varchar(2)), 'INT')", new byte[]{77, 0, 0, 0});
    }

    @Test
    public void testFixedInts11() throws Throwable {
        this.verifyPhysicalPlan("convert_to(77, 'BIGINT_BE')", new byte[]{0, 0, 0, 0, 0, 0, 0, 77});
    }

    @Test
    public void testFixedInts12() throws Throwable {
        this.verifyPhysicalPlan("convert_to(9223372036854775807, 'BIGINT')", new byte[]{-1, -1, -1, -1, -1, -1, -1, 127});
    }

    @Test
    public void testFixedInts13() throws Throwable {
        this.verifyPhysicalPlan("convert_to(-9223372036854775808, 'BIGINT')", new byte[]{0, 0, 0, 0, 0, 0, 0, -128});
    }

    @Test
    public void testVInts1() throws Throwable {
        this.verifyPhysicalPlan("convert_to(cast(0 as int), 'INT_HADOOPV')", new byte[]{0});
    }

    @Test
    public void testVInts2() throws Throwable {
        this.verifyPhysicalPlan("convert_to(cast(128 as int), 'INT_HADOOPV')", new byte[]{-113, -128});
    }

    @Test
    public void testVInts3() throws Throwable {
        this.verifyPhysicalPlan("convert_to(cast(256 as int), 'INT_HADOOPV')", new byte[]{-114, 1, 0});
    }

    @Test
    public void testVInts4() throws Throwable {
        this.verifyPhysicalPlan("convert_to(cast(65536 as int), 'INT_HADOOPV')", new byte[]{-115, 1, 0, 0});
    }

    @Test
    public void testVInts5() throws Throwable {
        this.verifyPhysicalPlan("convert_to(cast(16777216 as int), 'INT_HADOOPV')", new byte[]{-116, 1, 0, 0, 0});
    }

    @Test
    public void testVInts6() throws Throwable {
        this.verifyPhysicalPlan("convert_to(4294967296, 'BIGINT_HADOOPV')", new byte[]{-117, 1, 0, 0, 0, 0});
    }

    @Test
    public void testVInts7() throws Throwable {
        this.verifyPhysicalPlan("convert_to(1099511627776, 'BIGINT_HADOOPV')", new byte[]{-118, 1, 0, 0, 0, 0, 0});
    }

    @Test
    public void testVInts8() throws Throwable {
        this.verifyPhysicalPlan("convert_to(281474976710656, 'BIGINT_HADOOPV')", new byte[]{-119, 1, 0, 0, 0, 0, 0, 0});
    }

    @Test
    public void testVInts9() throws Throwable {
        this.verifyPhysicalPlan("convert_to(72057594037927936, 'BIGINT_HADOOPV')", new byte[]{-120, 1, 0, 0, 0, 0, 0, 0, 0});
    }

    @Test
    public void testVInts10() throws Throwable {
        this.verifyPhysicalPlan("convert_to(9223372036854775807, 'BIGINT_HADOOPV')", new byte[]{-120, 127, -1, -1, -1, -1, -1, -1, -1});
    }

    @Test
    public void testVInts11() throws Throwable {
        this.verifyPhysicalPlan("convert_from(binary_string('\\x88\\x7f\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF'), 'BIGINT_HADOOPV')", Long.MAX_VALUE);
    }

    @Test
    public void testVInts12() throws Throwable {
        this.verifyPhysicalPlan("convert_to(-9223372036854775808, 'BIGINT_HADOOPV')", new byte[]{-128, 127, -1, -1, -1, -1, -1, -1, -1});
    }

    @Test
    public void testVInts13() throws Throwable {
        this.verifyPhysicalPlan("convert_from(binary_string('\\x80\\x7f\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF'), 'BIGINT_HADOOPV')", Long.MIN_VALUE);
    }

    @Test
    public void testBool1() throws Throwable {
        this.verifyPhysicalPlan("convert_from(binary_string('\\x01'), 'BOOLEAN_BYTE')", true);
    }

    @Test
    public void testBool2() throws Throwable {
        this.verifyPhysicalPlan("convert_from(binary_string('\\x00'), 'BOOLEAN_BYTE')", false);
    }

    @Test
    public void testBool3() throws Throwable {
        this.verifyPhysicalPlan("convert_to(true, 'BOOLEAN_BYTE')", new byte[]{1});
    }

    @Test
    public void testBool4() throws Throwable {
        this.verifyPhysicalPlan("convert_to(false, 'BOOLEAN_BYTE')", new byte[]{0});
    }

    @Test
    public void testFloats1() throws Throwable {
    }

    @Test
    public void testFloats2() throws Throwable {
        this.verifyPhysicalPlan("convert_from(convert_to(cast(77 as float4), 'FLOAT'), 'FLOAT')", new Float(77.0));
    }

    @Test
    public void testFloats2be() throws Throwable {
        this.verifyPhysicalPlan("convert_from(convert_to(cast(77 as float4), 'FLOAT_BE'), 'FLOAT_BE')", new Float(77.0));
    }

    @Test
    public void testFloats3() throws Throwable {
        this.verifyPhysicalPlan("convert_to(cast(1.4e-45 as float4), 'FLOAT')", new byte[]{1, 0, 0, 0});
    }

    @Test
    public void testFloats4() throws Throwable {
        this.verifyPhysicalPlan("convert_to(cast(3.4028235e+38 as float4), 'FLOAT')", new byte[]{-1, -1, 127, 127});
    }

    @Test
    public void testFloats5(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        this.verifyPhysicalPlan("convert_from(convert_to(cast(77 as float8), 'DOUBLE'), 'DOUBLE')", 77.0);
    }

    @Test
    public void testFloats5be(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        this.verifyPhysicalPlan("convert_from(convert_to(cast(77 as float8), 'DOUBLE_BE'), 'DOUBLE_BE')", 77.0);
    }

    @Test
    public void testFloats6(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        this.verifyPhysicalPlan("convert_to(cast(77 as float8), 'DOUBLE')", new byte[]{0, 0, 0, 0, 0, 64, 83, 64});
    }

    @Test
    public void testFloats7(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        this.verifyPhysicalPlan("convert_to(4.9e-324, 'DOUBLE')", new byte[]{1, 0, 0, 0, 0, 0, 0, 0});
    }

    @Test
    public void testFloats8(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        this.verifyPhysicalPlan("convert_to(1.7976931348623157e+308, 'DOUBLE')", new byte[]{-1, -1, -1, -1, -1, -1, -17, 127});
    }

    @Test
    public void testUTF8() throws Throwable {
        this.verifyPhysicalPlan("convert_from(binary_string('apache_drill'), 'UTF8')", "apache_drill");
        this.verifyPhysicalPlan("convert_to('apache_drill', 'UTF8')", new byte[]{97, 112, 97, 99, 104, 101, 95, 100, 114, 105, 108, 108});
    }

    @Ignore
    @Test
    public void testBigIntVarCharReturnTripConvertLogical() throws Exception {
        String logicalPlan = Resources.toString((URL)Resources.getResource((String)CONVERSION_TEST_LOGICAL_PLAN), (Charset)Charsets.UTF_8);
        List<QueryDataBatch> results = TestConvertFunctions.testLogicalWithResults(logicalPlan);
        int count = 0;
        RecordBatchLoader loader = new RecordBatchLoader(TestConvertFunctions.getAllocator());
        for (QueryDataBatch result : results) {
            count += result.getHeader().getRowCount();
            loader.load(result.getHeader().getDef(), result.getData());
            if (loader.getRecordCount() > 0) {
                VectorUtil.showVectorAccessibleContent((VectorAccessible)loader);
            }
            loader.clear();
            result.release();
        }
        Assert.assertTrue((count == 10 ? 1 : 0) != 0);
    }

    private static OptionValue setupScalarReplacementOption(Drillbit drillbit, ClassTransformer.ScalarReplacementOption srOption) {
        DrillbitContext drillbitContext = drillbit.getContext();
        SystemOptionManager optionManager = drillbitContext.getOptionManager();
        OptionValue originalOptionValue = optionManager.getOption("org.apache.drill.exec.compile.ClassTransformer.scalar_replacement");
        OptionValue newOptionValue = OptionValue.createString((OptionValue.OptionType)OptionValue.OptionType.SYSTEM, (String)"org.apache.drill.exec.compile.ClassTransformer.scalar_replacement", (String)srOption.name().toLowerCase());
        optionManager.setOption(newOptionValue);
        drillbitContext.getCompiler().flushCache();
        return originalOptionValue;
    }

    private static void restoreScalarReplacementOption(Drillbit drillbit, OptionValue srOption) {
        DrillbitContext drillbitContext = drillbit.getContext();
        SystemOptionManager optionManager = drillbitContext.getOptionManager();
        optionManager.setOption(srOption);
        drillbitContext.getCompiler().flushCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBigIntVarCharReturnTripConvertLogical_ScalarReplaceTRY() throws Exception {
        OptionValue srOption = TestConvertFunctions.setupScalarReplacementOption(bits[0], ClassTransformer.ScalarReplacementOption.TRY);
        try {
            this.testBigIntVarCharReturnTripConvertLogical();
        }
        finally {
            TestConvertFunctions.restoreScalarReplacementOption(bits[0], srOption);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBigIntVarCharReturnTripConvertLogical_ScalarReplaceON() throws Exception {
        OptionValue srOption = TestConvertFunctions.setupScalarReplacementOption(bits[0], ClassTransformer.ScalarReplacementOption.ON);
        boolean caughtException = false;
        try {
            this.testBigIntVarCharReturnTripConvertLogical();
        }
        catch (RpcException e) {
            caughtException = true;
        }
        finally {
            TestConvertFunctions.restoreScalarReplacementOption(bits[0], srOption);
        }
        Assert.assertTrue((boolean)caughtException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBigIntVarCharReturnTripConvertLogical_ScalarReplaceOFF() throws Exception {
        OptionValue srOption = TestConvertFunctions.setupScalarReplacementOption(bits[0], ClassTransformer.ScalarReplacementOption.OFF);
        try {
            this.testBigIntVarCharReturnTripConvertLogical();
        }
        finally {
            TestConvertFunctions.restoreScalarReplacementOption(bits[0], srOption);
        }
    }

    @Test
    public void testHadooopVInt() throws Exception {
        boolean _0 = false;
        int _9 = 9;
        DrillBuf buffer = TestConvertFunctions.getAllocator().buffer(9);
        long longVal = 0L;
        buffer.clear();
        ByteBufUtil.HadoopWritables.writeVLong((DrillBuf)buffer, (int)0, (int)9, (long)0L);
        longVal = ByteBufUtil.HadoopWritables.readVLong((DrillBuf)buffer, (int)0, (int)9);
        Assert.assertEquals((long)longVal, (long)0L);
        buffer.clear();
        ByteBufUtil.HadoopWritables.writeVLong((DrillBuf)buffer, (int)0, (int)9, (long)Long.MAX_VALUE);
        longVal = ByteBufUtil.HadoopWritables.readVLong((DrillBuf)buffer, (int)0, (int)9);
        Assert.assertEquals((long)longVal, (long)Long.MAX_VALUE);
        buffer.clear();
        ByteBufUtil.HadoopWritables.writeVLong((DrillBuf)buffer, (int)0, (int)9, (long)Long.MIN_VALUE);
        longVal = ByteBufUtil.HadoopWritables.readVLong((DrillBuf)buffer, (int)0, (int)9);
        Assert.assertEquals((long)longVal, (long)Long.MIN_VALUE);
        int intVal = 0;
        buffer.clear();
        ByteBufUtil.HadoopWritables.writeVInt((DrillBuf)buffer, (int)0, (int)9, (int)0);
        intVal = ByteBufUtil.HadoopWritables.readVInt((DrillBuf)buffer, (int)0, (int)9);
        Assert.assertEquals((long)intVal, (long)0L);
        buffer.clear();
        ByteBufUtil.HadoopWritables.writeVInt((DrillBuf)buffer, (int)0, (int)9, (int)Integer.MAX_VALUE);
        intVal = ByteBufUtil.HadoopWritables.readVInt((DrillBuf)buffer, (int)0, (int)9);
        Assert.assertEquals((long)intVal, (long)Integer.MAX_VALUE);
        buffer.clear();
        ByteBufUtil.HadoopWritables.writeVInt((DrillBuf)buffer, (int)0, (int)9, (int)Integer.MIN_VALUE);
        intVal = ByteBufUtil.HadoopWritables.readVInt((DrillBuf)buffer, (int)0, (int)9);
        Assert.assertEquals((long)intVal, (long)Integer.MIN_VALUE);
        buffer.release();
    }

    protected <T> void verifySQL(String sql, T expectedResults) throws Throwable {
        this.verifyResults(sql, expectedResults, this.getRunResult(UserBitShared.QueryType.SQL, sql));
    }

    protected <T> void verifyPhysicalPlan(String expression, T expectedResults) throws Throwable {
        expression = expression.replace("\\", "\\\\\\\\");
        if (this.textFileContent == null) {
            this.textFileContent = Resources.toString((URL)Resources.getResource((String)CONVERSION_TEST_PHYSICAL_PLAN), (Charset)Charsets.UTF_8);
        }
        String planString = this.textFileContent.replace("__CONVERT_EXPRESSION__", expression);
        this.verifyResults(expression, expectedResults, this.getRunResult(UserBitShared.QueryType.PHYSICAL, planString));
    }

    protected Object[] getRunResult(UserBitShared.QueryType queryType, String planString) throws Exception {
        List<QueryDataBatch> resultList = TestConvertFunctions.testRunAndReturn(queryType, planString);
        ArrayList<Object> res = new ArrayList<Object>();
        RecordBatchLoader loader = new RecordBatchLoader(TestConvertFunctions.getAllocator());
        for (QueryDataBatch result : resultList) {
            if (result.getData() == null) continue;
            loader.load(result.getHeader().getDef(), result.getData());
            ValueVector v = ((VectorWrapper)loader.iterator().next()).getValueVector();
            for (int j = 0; j < v.getAccessor().getValueCount(); ++j) {
                if (v instanceof VarCharVector) {
                    res.add(new String(((VarCharVector)v).getAccessor().get(j)));
                    continue;
                }
                res.add(v.getAccessor().getObject(j));
            }
            loader.clear();
            result.release();
        }
        return res.toArray();
    }

    protected <T> void verifyResults(String expression, T expectedResults, Object[] actualResults) throws Throwable {
        String testName = String.format("Expression: %s.", expression);
        Assert.assertEquals((String)testName, (long)1L, (long)actualResults.length);
        Assert.assertNotNull((String)testName, (Object)actualResults[0]);
        if (expectedResults.getClass().isArray()) {
            this.assertArraysEquals(testName, expectedResults, actualResults[0]);
        } else {
            Assert.assertEquals((String)testName, expectedResults, (Object)actualResults[0]);
        }
    }

    protected void assertArraysEquals(Object expected, Object actual) {
        this.assertArraysEquals(null, expected, actual);
    }

    protected void assertArraysEquals(String message, Object expected, Object actual) {
        if (expected instanceof byte[] && actual instanceof byte[]) {
            Assert.assertArrayEquals((String)message, (byte[])((byte[])expected), (byte[])((byte[])actual));
        } else if (expected instanceof Object[] && actual instanceof Object[]) {
            Assert.assertArrayEquals((String)message, (Object[])((Object[])expected), (Object[])((Object[])actual));
        } else if (expected instanceof char[] && actual instanceof char[]) {
            Assert.assertArrayEquals((String)message, (char[])((char[])expected), (char[])((char[])actual));
        } else if (expected instanceof short[] && actual instanceof short[]) {
            Assert.assertArrayEquals((String)message, (short[])((short[])expected), (short[])((short[])actual));
        } else if (expected instanceof int[] && actual instanceof int[]) {
            Assert.assertArrayEquals((String)message, (int[])((int[])expected), (int[])((int[])actual));
        } else if (expected instanceof long[] && actual instanceof long[]) {
            Assert.assertArrayEquals((String)message, (long[])((long[])expected), (long[])((long[])actual));
        } else if (expected instanceof float[] && actual instanceof float[]) {
            Assert.assertArrayEquals((String)message, (float[])((float[])expected), (float[])((float[])actual), (float)1.0E-4f);
        } else if (expected instanceof double[] && actual instanceof double[]) {
            Assert.assertArrayEquals((String)message, (double[])((double[])expected), (double[])((double[])actual), (double)1.0E-4f);
        } else {
            Assert.fail((String)String.format("%s: Error comparing arrays of type '%s' and '%s'", expected.getClass().getName(), actual == null ? "null" : actual.getClass().getName()));
        }
    }
}

