/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import mockit.Injectable;
import mockit.NonStrictExpectations;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.compile.CodeCompiler;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import org.apache.drill.exec.physical.impl.SimpleRootExec;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.DrillbitContext;
import org.junit.Assert;
import org.junit.Test;

public class TestComparisonFunctions
extends ExecTest {
    private final DrillConfig c = DrillConfig.create();
    private final String COMPARISON_TEST_PHYSICAL_PLAN = "functions/comparisonTest.json";
    private PhysicalPlanReader reader;
    private FunctionImplementationRegistry registry;

    public void runTest(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection, String expression, int expectedResults) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestComparisonFunctions.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestComparisonFunctions.this.c);
                bitContext.getConfig();
                result = TestComparisonFunctions.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestComparisonFunctions.this.c);
            }
        };
        String planString = Resources.toString((URL)Resources.getResource((String)"functions/comparisonTest.json"), (Charset)Charsets.UTF_8).replaceAll("EXPRESSION", expression);
        if (this.reader == null) {
            this.reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        }
        if (this.registry == null) {
            this.registry = new FunctionImplementationRegistry(this.c);
        }
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, this.registry);
        PhysicalPlan plan = this.reader.readPhysicalPlan(planString);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        while (exec.next()) {
            Assert.assertEquals((String)String.format("Expression: %s;", expression), (long)expectedResults, (long)exec.getSelectionVector2().getCount());
        }
        exec.close();
        context.close();
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void testInt(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        this.runTest(bitContext, connection, "intColumn == intColumn", 100);
        this.runTest(bitContext, connection, "intColumn != intColumn", 0);
        this.runTest(bitContext, connection, "intColumn > intColumn", 0);
        this.runTest(bitContext, connection, "intColumn < intColumn", 0);
        this.runTest(bitContext, connection, "intColumn >= intColumn", 100);
        this.runTest(bitContext, connection, "intColumn <= intColumn", 100);
    }

    @Test
    public void testBigInt(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        this.runTest(bitContext, connection, "bigIntColumn == bigIntColumn", 100);
        this.runTest(bitContext, connection, "bigIntColumn != bigIntColumn", 0);
        this.runTest(bitContext, connection, "bigIntColumn > bigIntColumn", 0);
        this.runTest(bitContext, connection, "bigIntColumn < bigIntColumn", 0);
        this.runTest(bitContext, connection, "bigIntColumn >= bigIntColumn", 100);
        this.runTest(bitContext, connection, "bigIntColumn <= bigIntColumn", 100);
    }

    @Test
    public void testFloat4(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        this.runTest(bitContext, connection, "float4Column == float4Column", 100);
        this.runTest(bitContext, connection, "float4Column != float4Column", 0);
        this.runTest(bitContext, connection, "float4Column > float4Column", 0);
        this.runTest(bitContext, connection, "float4Column < float4Column", 0);
        this.runTest(bitContext, connection, "float4Column >= float4Column", 100);
        this.runTest(bitContext, connection, "float4Column <= float4Column", 100);
    }

    @Test
    public void testFloat8(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        this.runTest(bitContext, connection, "float8Column == float8Column", 100);
        this.runTest(bitContext, connection, "float8Column != float8Column", 0);
        this.runTest(bitContext, connection, "float8Column > float8Column", 0);
        this.runTest(bitContext, connection, "float8Column < float8Column", 0);
        this.runTest(bitContext, connection, "float8Column >= float8Column", 100);
        this.runTest(bitContext, connection, "float8Column <= float8Column", 100);
    }

    @Test
    public void testIntNullable(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        this.runTest(bitContext, connection, "intNullableColumn == intNullableColumn", 50);
        this.runTest(bitContext, connection, "intNullableColumn != intNullableColumn", 0);
        this.runTest(bitContext, connection, "intNullableColumn > intNullableColumn", 0);
        this.runTest(bitContext, connection, "intNullableColumn < intNullableColumn", 0);
        this.runTest(bitContext, connection, "intNullableColumn >= intNullableColumn", 50);
        this.runTest(bitContext, connection, "intNullableColumn <= intNullableColumn", 50);
    }

    @Test
    public void testBigIntNullable(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        this.runTest(bitContext, connection, "bigIntNullableColumn == bigIntNullableColumn", 50);
        this.runTest(bitContext, connection, "bigIntNullableColumn != bigIntNullableColumn", 0);
        this.runTest(bitContext, connection, "bigIntNullableColumn > bigIntNullableColumn", 0);
        this.runTest(bitContext, connection, "bigIntNullableColumn < bigIntNullableColumn", 0);
        this.runTest(bitContext, connection, "bigIntNullableColumn >= bigIntNullableColumn", 50);
        this.runTest(bitContext, connection, "bigIntNullableColumn <= bigIntNullableColumn", 50);
    }
}

