/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Assert;
import org.junit.Test;

public class TestCastVarCharToBigInt
extends PopUnitTestBase {
    @Test
    public void testCastToBigInt() throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/functions/cast/test_cast_varchar_to_bigint.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", "/scan_json_test_cast.json"));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(0);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            for (VectorWrapper v : batchLoader) {
                ValueVector.Accessor accessor = v.getValueVector().getAccessor();
                Assert.assertEquals((Object)accessor.getObject(0), (Object)2008L);
                Assert.assertEquals((Object)accessor.getObject(1), (Object)2007L);
                Assert.assertEquals((Object)accessor.getObject(2), (Object)2006L);
            }
            for (QueryDataBatch b : results) {
                b.release();
            }
            batchLoader.clear();
        }
    }
}

