/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import io.netty.buffer.DrillBuf;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import mockit.Injectable;
import mockit.NonStrictExpectations;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.compile.CodeCompiler;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import org.apache.drill.exec.physical.impl.SimpleRootExec;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.Float4Vector;
import org.apache.drill.exec.vector.Float8Vector;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.VarBinaryVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.junit.Assert;
import org.junit.Test;

public class TestCastFunctions
extends PopUnitTestBase {
    private final DrillConfig c = DrillConfig.create();

    @Test
    public void testCastBigInt(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        final BufferAllocator allocator = RootAllocatorFactory.newRoot((DrillConfig)this.c);
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = allocator;
                bitContext.getConfig();
                result = TestCastFunctions.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestCastFunctions.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestCastFunctions.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/functions/cast/testCastBigInt.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        while (exec.next()) {
            BigIntVector c0 = (BigIntVector)((Object)exec.getValueVectorById(new SchemaPath("varchar_cast", ExpressionPosition.UNKNOWN), BigIntVector.class));
            BigIntVector.Accessor a0 = c0.getAccessor();
            int count = 0;
            for (int i = 0; i < c0.getAccessor().getValueCount(); ++i) {
                BigIntHolder holder0 = new BigIntHolder();
                a0.get(i, holder0);
                Assert.assertEquals((long)1256L, (long)holder0.value);
                ++count;
            }
            Assert.assertEquals((long)5L, (long)count);
        }
        exec.close();
        context.close();
        allocator.close();
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void testCastInt(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        final BufferAllocator allocator = RootAllocatorFactory.newRoot((DrillConfig)this.c);
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = allocator;
                bitContext.getConfig();
                result = TestCastFunctions.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestCastFunctions.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestCastFunctions.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/functions/cast/testCastInt.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        while (exec.next()) {
            IntVector c0 = (IntVector)((Object)exec.getValueVectorById(new SchemaPath("varchar_cast", ExpressionPosition.UNKNOWN), IntVector.class));
            IntVector.Accessor a0 = c0.getAccessor();
            int count = 0;
            for (int i = 0; i < c0.getAccessor().getValueCount(); ++i) {
                IntHolder holder0 = new IntHolder();
                a0.get(i, holder0);
                Assert.assertEquals((long)1256L, (long)holder0.value);
                ++count;
            }
            Assert.assertEquals((long)5L, (long)count);
        }
        exec.close();
        context.close();
        allocator.close();
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void testCastFloat4(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        final BufferAllocator allocator = RootAllocatorFactory.newRoot((DrillConfig)this.c);
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = allocator;
                bitContext.getConfig();
                result = TestCastFunctions.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestCastFunctions.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestCastFunctions.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/functions/cast/testCastFloat4.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        while (exec.next()) {
            Float4Vector c0 = (Float4Vector)((Object)exec.getValueVectorById(new SchemaPath("varchar_cast2", ExpressionPosition.UNKNOWN), Float4Vector.class));
            Float4Vector.Accessor a0 = c0.getAccessor();
            int count = 0;
            for (int i = 0; i < c0.getAccessor().getValueCount(); ++i) {
                Float4Holder holder0 = new Float4Holder();
                a0.get(i, holder0);
                Assert.assertEquals((double)12.56, (double)holder0.value, (double)0.001);
                ++count;
            }
            Assert.assertEquals((long)5L, (long)count);
        }
        exec.close();
        context.close();
        allocator.close();
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void testCastFloat8(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        final BufferAllocator allocator = RootAllocatorFactory.newRoot((DrillConfig)this.c);
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = allocator;
                bitContext.getConfig();
                result = TestCastFunctions.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestCastFunctions.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestCastFunctions.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/functions/cast/testCastFloat8.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        while (exec.next()) {
            Float8Vector c0 = (Float8Vector)((Object)exec.getValueVectorById(new SchemaPath("varchar_cast2", ExpressionPosition.UNKNOWN), Float8Vector.class));
            Float8Vector.Accessor a0 = c0.getAccessor();
            int count = 0;
            for (int i = 0; i < c0.getAccessor().getValueCount(); ++i) {
                Float8Holder holder0 = new Float8Holder();
                a0.get(i, holder0);
                Assert.assertEquals((double)12.56, (double)holder0.value, (double)0.001);
                ++count;
            }
            Assert.assertEquals((long)5L, (long)count);
        }
        exec.close();
        context.close();
        allocator.close();
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void testCastVarChar(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        final BufferAllocator allocator = RootAllocatorFactory.newRoot((DrillConfig)this.c);
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = allocator;
                bitContext.getConfig();
                result = TestCastFunctions.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestCastFunctions.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestCastFunctions.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/functions/cast/testCastVarChar.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        while (exec.next()) {
            VarCharVector c0 = (VarCharVector)((Object)exec.getValueVectorById(new SchemaPath("int_lit_cast", ExpressionPosition.UNKNOWN), VarCharVector.class));
            VarCharVector.Accessor a0 = c0.getAccessor();
            int count = 0;
            for (int i = 0; i < c0.getAccessor().getValueCount(); ++i) {
                VarCharHolder holder0 = new VarCharHolder();
                a0.get(i, holder0);
                Assert.assertEquals((Object)"123", (Object)StringFunctionHelpers.toStringFromUTF8((int)holder0.start, (int)holder0.end, (DrillBuf)holder0.buffer));
                ++count;
            }
            Assert.assertEquals((long)5L, (long)count);
        }
        exec.close();
        context.close();
        allocator.close();
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void testCastVarBinary(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        final BufferAllocator allocator = RootAllocatorFactory.newRoot((DrillConfig)this.c);
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = allocator;
                bitContext.getConfig();
                result = TestCastFunctions.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestCastFunctions.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestCastFunctions.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/functions/cast/testCastVarBinary.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        while (exec.next()) {
            VarBinaryVector c0 = (VarBinaryVector)((Object)exec.getValueVectorById(new SchemaPath("int_lit_cast", ExpressionPosition.UNKNOWN), VarBinaryVector.class));
            VarBinaryVector.Accessor a0 = c0.getAccessor();
            int count = 0;
            for (int i = 0; i < c0.getAccessor().getValueCount(); ++i) {
                VarBinaryHolder holder0 = new VarBinaryHolder();
                a0.get(i, holder0);
                Assert.assertEquals((Object)"123", (Object)StringFunctionHelpers.toStringFromUTF8((int)holder0.start, (int)holder0.end, (DrillBuf)holder0.buffer));
                ++count;
            }
            Assert.assertEquals((long)5L, (long)count);
        }
        exec.close();
        context.close();
        allocator.close();
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void testCastNested(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        final BufferAllocator allocator = RootAllocatorFactory.newRoot((DrillConfig)this.c);
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = allocator;
                bitContext.getConfig();
                result = TestCastFunctions.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestCastFunctions.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestCastFunctions.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/functions/cast/testCastNested.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        while (exec.next()) {
            IntVector c0 = (IntVector)((Object)exec.getValueVectorById(new SchemaPath("add_cast", ExpressionPosition.UNKNOWN), IntVector.class));
            IntVector.Accessor a0 = c0.getAccessor();
            int count = 0;
            for (int i = 0; i < c0.getAccessor().getValueCount(); ++i) {
                IntHolder holder0 = new IntHolder();
                a0.get(i, holder0);
                Assert.assertEquals((long)300L, (long)holder0.value);
                ++count;
            }
            Assert.assertEquals((long)5L, (long)count);
        }
        exec.close();
        context.close();
        allocator.close();
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test(expected=NumberFormatException.class)
    public void testCastNumException(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        final BufferAllocator allocator = RootAllocatorFactory.newRoot((DrillConfig)this.c);
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = allocator;
                bitContext.getConfig();
                result = TestCastFunctions.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestCastFunctions.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestCastFunctions.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/functions/cast/testCastNumException.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        while (exec.next()) {
        }
        exec.close();
        context.close();
        allocator.close();
        Assert.assertTrue((boolean)context.isFailed());
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
    }

    @Test
    public void testCastFromNullablCol() throws Throwable {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/functions/cast/testCastVarCharNull.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", "/jsoninput/input1.json"));
            QueryDataBatch batch = (QueryDataBatch)results.get(0);
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            batchLoader.load(batch.getHeader().getDef(), batch.getData());
            Object[][] result = this.getRunResult((VectorAccessible)batchLoader);
            Object[][] expected = new Object[2][2];
            expected[0][0] = new String("2001");
            expected[0][1] = new String("1.2");
            expected[1][0] = new String("-2002");
            expected[1][1] = new String("-1.2");
            Assert.assertEquals((long)result.length, (long)expected.length);
            Assert.assertEquals((long)result[0].length, (long)expected[0].length);
            for (int i = 0; i < result.length; ++i) {
                for (int j = 0; j < result[0].length; ++j) {
                    Assert.assertEquals((String)String.format("Column %s at row %s have wrong result", j, i), (Object)result[i][j].toString(), (Object)expected[i][j]);
                }
            }
            batchLoader.clear();
            for (QueryDataBatch b : results) {
                b.release();
            }
        }
    }

    private Object[][] getRunResult(VectorAccessible va) {
        int size = 0;
        for (VectorWrapper v : va) {
            ++size;
        }
        Object[][] res = new Object[va.getRecordCount()][size];
        for (int j = 0; j < va.getRecordCount(); ++j) {
            int i = 0;
            for (VectorWrapper v : va) {
                Object o = v.getValueVector().getAccessor().getObject(j);
                if (o instanceof byte[]) {
                    res[j][i++] = new String((byte[])o);
                    continue;
                }
                res[j][i++] = o;
            }
        }
        return res;
    }
}

