/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.junit.Assert;
import org.junit.Test;

public class TestBroadcastExchange
extends PopUnitTestBase {
    @Test
    public void TestSingleBroadcastExchangeWithTwoScans() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             Drillbit bit2 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            bit2.run();
            client.connect();
            String physicalPlan = Files.toString((File)FileUtils.getResourceAsFile((String)"/sender/broadcast_exchange.json"), (Charset)Charsets.UTF_8).replace("#{LEFT_FILE}", FileUtils.getResourceAsFile((String)"/join/merge_single_batch.left.json").toURI().toString()).replace("#{RIGHT_FILE}", FileUtils.getResourceAsFile((String)"/join/merge_single_batch.right.json").toURI().toString());
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, physicalPlan);
            int count = 0;
            for (QueryDataBatch b : results) {
                if (b.getHeader().getRowCount() != 0) {
                    count += b.getHeader().getRowCount();
                }
                b.release();
            }
            Assert.assertEquals((long)25L, (long)count);
        }
    }

    @Test
    public void TestMultipleSendLocationBroadcastExchange() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             Drillbit bit2 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            bit2.run();
            client.connect();
            String physicalPlan = Files.toString((File)FileUtils.getResourceAsFile((String)"/sender/broadcast_exchange_long_run.json"), (Charset)Charsets.UTF_8);
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, physicalPlan);
            int count = 0;
            for (QueryDataBatch b : results) {
                if (b.getHeader().getRowCount() != 0) {
                    count += b.getHeader().getRowCount();
                }
                b.release();
            }
            System.out.println(count);
        }
    }
}

