/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.memory;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import io.netty.buffer.DrillBuf;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OpProfileDef;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.ops.OperatorStats;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.junit.Assert;
import org.junit.Test;

public class TestAllocators {
    private static final Properties TEST_CONFIGURATIONS = new Properties(){
        {
            this.put("drill.exec.memory.top.max", "14000000");
            this.put("drill.exec.memory.enable_frag_limit", "true");
            this.put("drill.exec.memory.frag_mem_overcommit_factor", "1.1");
        }
    };
    private static final String planFile = "/physical_allocator_test.json";

    @Test
    public void testTransfer() throws Exception {
        Properties props = new Properties(){
            {
                this.put("drill.exec.memory.top.max", "1000000");
                this.put("drill.exec.debug.error_on_leak", "true");
            }
        };
        DrillConfig config = DrillConfig.create((Properties)props);
        BufferAllocator a = RootAllocatorFactory.newRoot((DrillConfig)config);
        BufferAllocator b = RootAllocatorFactory.newRoot((DrillConfig)config);
        DrillBuf buf1 = a.buffer(1000000);
        DrillBuf buf2 = b.buffer(1000);
        b.takeOwnership(buf1);
        buf1.release();
        buf2.release();
        a.close();
        b.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllocators() throws Exception {
        DrillConfig config = DrillConfig.create((Properties)TEST_CONFIGURATIONS);
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        Drillbit bit = new Drillbit(config, serviceSet);
        bit.run();
        DrillbitContext bitContext = bit.getContext();
        FunctionImplementationRegistry functionRegistry = bitContext.getFunctionImplementationRegistry();
        StoragePluginRegistry storageRegistry = new StoragePluginRegistry(bitContext);
        BitControl.PlanFragment.Builder pfBuilder1 = BitControl.PlanFragment.newBuilder();
        pfBuilder1.setMemInitial(1500000L);
        BitControl.PlanFragment pf1 = pfBuilder1.build();
        BitControl.PlanFragment.Builder pfBuilder2 = BitControl.PlanFragment.newBuilder();
        pfBuilder2.setMemInitial(500000L);
        BitControl.PlanFragment pf2 = pfBuilder1.build();
        FragmentContext fragmentContext1 = new FragmentContext(bitContext, pf1, null, functionRegistry);
        FragmentContext fragmentContext2 = new FragmentContext(bitContext, pf2, null, functionRegistry);
        PhysicalPlanReader planReader = new PhysicalPlanReader(config, config.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance(), storageRegistry);
        PhysicalPlan plan = planReader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)planFile), (Charset)Charsets.UTF_8));
        List physicalOperators = plan.getSortedOperators();
        Iterator physicalOperatorIterator = physicalOperators.iterator();
        PhysicalOperator physicalOperator1 = (PhysicalOperator)physicalOperatorIterator.next();
        PhysicalOperator physicalOperator2 = (PhysicalOperator)physicalOperatorIterator.next();
        PhysicalOperator physicalOperator3 = (PhysicalOperator)physicalOperatorIterator.next();
        PhysicalOperator physicalOperator4 = (PhysicalOperator)physicalOperatorIterator.next();
        PhysicalOperator physicalOperator5 = (PhysicalOperator)physicalOperatorIterator.next();
        PhysicalOperator physicalOperator6 = (PhysicalOperator)physicalOperatorIterator.next();
        OpProfileDef def = new OpProfileDef(physicalOperator1.getOperatorId(), 24, OperatorContext.getChildCount((PhysicalOperator)physicalOperator1));
        OperatorStats stats = fragmentContext1.getStats().getOperatorStats(def, fragmentContext1.getAllocator());
        OperatorContext oContext11 = fragmentContext1.newOperatorContext(physicalOperator1, true);
        DrillBuf b11 = oContext11.getAllocator().buffer(1000000);
        OperatorContext oContext12 = fragmentContext1.newOperatorContext(physicalOperator2, stats, true);
        DrillBuf b12 = oContext12.getAllocator().buffer(500000);
        OperatorContext oContext21 = fragmentContext1.newOperatorContext(physicalOperator3, true);
        def = new OpProfileDef(physicalOperator4.getOperatorId(), 27, OperatorContext.getChildCount((PhysicalOperator)physicalOperator4));
        stats = fragmentContext2.getStats().getOperatorStats(def, fragmentContext2.getAllocator());
        OperatorContext oContext22 = fragmentContext2.newOperatorContext(physicalOperator4, stats, true);
        DrillBuf b22 = oContext22.getAllocator().buffer(2000000);
        BitControl.PlanFragment.Builder pfBuilder3 = BitControl.PlanFragment.newBuilder();
        pfBuilder3.setMemInitial(1000000L);
        BitControl.PlanFragment pf3 = pfBuilder3.build();
        FragmentContext fragmentContext3 = new FragmentContext(bitContext, pf3, null, functionRegistry);
        def = new OpProfileDef(physicalOperator5.getOperatorId(), 19, OperatorContext.getChildCount((PhysicalOperator)physicalOperator5));
        stats = fragmentContext3.getStats().getOperatorStats(def, fragmentContext3.getAllocator());
        OperatorContext oContext31 = fragmentContext3.newOperatorContext(physicalOperator5, stats, true);
        DrillBuf b31a = oContext31.getAllocator().buffer(200000);
        b22.release();
        ((AutoCloseable)oContext22).close();
        try {
            oContext31.getAllocator().buffer(4400000);
            Assert.fail((String)"Fragment 3 should fail to allocate buffer");
        }
        catch (OutOfMemoryRuntimeException outOfMemoryRuntimeException) {
            // empty catch block
        }
        OperatorContext oContext32 = fragmentContext3.newOperatorContext(physicalOperator6, false);
        try {
            DrillBuf b32 = oContext32.getAllocator().buffer(4400000);
            b32.release();
        }
        catch (OutOfMemoryRuntimeException e) {
            Assert.fail((String)"Fragment 3 failed to allocate buffer");
        }
        finally {
            this.closeOp(oContext32);
        }
        b11.release();
        this.closeOp(oContext11);
        b12.release();
        this.closeOp(oContext12);
        this.closeOp(oContext21);
        b31a.release();
        this.closeOp(oContext31);
        fragmentContext1.close();
        fragmentContext2.close();
        fragmentContext3.close();
        bit.close();
        serviceSet.close();
    }

    private void closeOp(OperatorContext c) throws Exception {
        ((AutoCloseable)c).close();
    }
}

