/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.impersonation;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.exec.dotdrill.DotDrillType;
import org.apache.drill.exec.impersonation.BaseTestImpersonation;
import org.apache.drill.exec.store.dfs.WorkspaceConfig;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestImpersonationQueries
extends BaseTestImpersonation {
    @BeforeClass
    public static void setup() throws Exception {
        TestImpersonationQueries.startMiniDfsCluster(TestImpersonationQueries.class.getSimpleName());
        TestImpersonationQueries.startDrillCluster(true);
        TestImpersonationQueries.addMiniDfsBasedStorage(TestImpersonationQueries.createTestWorkspaces());
        TestImpersonationQueries.createTestData();
    }

    private static void createTestData() throws Exception {
        TestImpersonationQueries.createTestTable(org1Users[0], org1Groups[0], "lineitem");
        TestImpersonationQueries.createTestTable(org2Users[0], org2Groups[0], "orders");
        TestImpersonationQueries.createNestedTestViewsOnLineItem();
        TestImpersonationQueries.createNestedTestViewsOnOrders();
    }

    private static String getUserHome(String user) {
        return "/user/" + user;
    }

    private static String getWSSchema(String user) {
        return "miniDfsPlugin." + user;
    }

    private static Map<String, WorkspaceConfig> createTestWorkspaces() throws Exception {
        String group;
        String user;
        int i;
        Path tmpPath = new Path("/tmp");
        fs.delete(tmpPath, true);
        FileSystem.mkdirs((FileSystem)fs, (Path)tmpPath, (FsPermission)new FsPermission(511));
        HashMap workspaces = Maps.newHashMap();
        for (i = 0; i < org1Users.length; ++i) {
            user = org1Users[i];
            group = org1Groups[i];
            TestImpersonationQueries.createAndAddWorkspace(user, TestImpersonationQueries.getUserHome(user), (short)493, user, group, workspaces);
        }
        for (i = 0; i < org2Users.length; ++i) {
            user = org2Users[i];
            group = org2Groups[i];
            TestImpersonationQueries.createAndAddWorkspace(user, TestImpersonationQueries.getUserHome(user), (short)493, user, group, workspaces);
        }
        return workspaces;
    }

    private static void createTestTable(String user, String group, String tableName) throws Exception {
        TestImpersonationQueries.updateClient(user);
        TestImpersonationQueries.test("USE " + TestImpersonationQueries.getWSSchema(user));
        TestImpersonationQueries.test(String.format("CREATE TABLE %s as SELECT * FROM cp.`tpch/%s.parquet`;", tableName, tableName));
        Path tablePath = new Path(TestImpersonationQueries.getUserHome(user), tableName);
        fs.setOwner(tablePath, user, group);
        fs.setPermission(tablePath, new FsPermission(488));
    }

    private static void createNestedTestViewsOnLineItem() throws Exception {
        TestImpersonationQueries.createView(org1Users[1], org1Groups[1], (short)488, "u1_lineitem", TestImpersonationQueries.getWSSchema(org1Users[0]), "lineitem");
        TestImpersonationQueries.createView(org1Users[2], org1Groups[2], (short)488, "u2_lineitem", TestImpersonationQueries.getWSSchema(org1Users[1]), "u1_lineitem");
        TestImpersonationQueries.createView(org1Users[2], org1Groups[2], (short)488, "u22_lineitem", TestImpersonationQueries.getWSSchema(org1Users[2]), "u2_lineitem");
        TestImpersonationQueries.createView(org1Users[3], org1Groups[3], (short)488, "u3_lineitem", TestImpersonationQueries.getWSSchema(org1Users[2]), "u22_lineitem");
        TestImpersonationQueries.createView(org1Users[4], org1Groups[4], (short)493, "u4_lineitem", TestImpersonationQueries.getWSSchema(org1Users[3]), "u3_lineitem");
    }

    private static void createNestedTestViewsOnOrders() throws Exception {
        TestImpersonationQueries.createView(org2Users[1], org2Groups[1], (short)488, "u1_orders", TestImpersonationQueries.getWSSchema(org2Users[0]), "orders");
        TestImpersonationQueries.createView(org2Users[2], org2Groups[2], (short)488, "u2_orders", TestImpersonationQueries.getWSSchema(org2Users[1]), "u1_orders");
        TestImpersonationQueries.createView(org2Users[2], org2Groups[2], (short)488, "u22_orders", TestImpersonationQueries.getWSSchema(org2Users[2]), "u2_orders");
        TestImpersonationQueries.createView(org2Users[3], org2Groups[3], (short)493, "u3_orders", TestImpersonationQueries.getWSSchema(org2Users[2]), "u22_orders");
        TestImpersonationQueries.createView(org2Users[4], org2Groups[4], (short)493, "u4_orders", TestImpersonationQueries.getWSSchema(org2Users[3]), "u3_orders");
    }

    private static void createView(String viewOwner, String viewGroup, short viewPerms, String newViewName, String fromSourceSchema, String fromSourceTableName) throws Exception {
        TestImpersonationQueries.updateClient(viewOwner);
        TestImpersonationQueries.test(String.format("ALTER SESSION SET `%s`='%o';", "new_view_default_permissions", viewPerms));
        TestImpersonationQueries.test(String.format("CREATE VIEW %s.%s AS SELECT * FROM %s.%s;", TestImpersonationQueries.getWSSchema(viewOwner), newViewName, fromSourceSchema, fromSourceTableName));
        Path viewFilePath = new Path(TestImpersonationQueries.getUserHome(viewOwner), newViewName + DotDrillType.VIEW.getEnding());
        FileStatus status = fs.getFileStatus(viewFilePath);
        Assert.assertEquals((Object)viewGroup, (Object)status.getGroup());
        Assert.assertEquals((Object)viewOwner, (Object)status.getOwner());
        Assert.assertEquals((long)viewPerms, (long)status.getPermission().toShort());
    }

    @Test
    public void testDirectImpersonation_HasUserReadPermissions() throws Exception {
        TestImpersonationQueries.updateClient(org1Users[0]);
        TestImpersonationQueries.test(String.format("SELECT * FROM %s.lineitem ORDER BY l_orderkey LIMIT 1", TestImpersonationQueries.getWSSchema(org1Users[0])));
    }

    @Test
    public void testDirectImpersonation_HasGroupReadPermissions() throws Exception {
        TestImpersonationQueries.updateClient(org1Users[1]);
        TestImpersonationQueries.test(String.format("SELECT * FROM %s.lineitem ORDER BY l_orderkey LIMIT 1", TestImpersonationQueries.getWSSchema(org1Users[0])));
    }

    @Test
    public void testDirectImpersonation_NoReadPermissions() throws Exception {
        UserRemoteException ex = null;
        try {
            TestImpersonationQueries.updateClient(org1Users[2]);
            TestImpersonationQueries.test(String.format("SELECT * FROM %s.lineitem ORDER BY l_orderkey LIMIT 1", TestImpersonationQueries.getWSSchema(org1Users[0])));
        }
        catch (UserRemoteException e) {
            ex = e;
        }
        Assert.assertNotNull((String)"UserRemoteException is expected", (Object)((Object)ex));
        Assert.assertThat((Object)ex.getMessage(), (Matcher)StringContains.containsString((String)("PERMISSION ERROR: " + String.format("Not authorized to read table [lineitem] in schema [%s.user0_1]", "miniDfsPlugin"))));
    }

    @Test
    public void testMultiLevelImpersonationEqualToMaxUserHops() throws Exception {
        TestImpersonationQueries.updateClient(org1Users[4]);
        TestImpersonationQueries.test(String.format("SELECT * from %s.u4_lineitem LIMIT 1;", TestImpersonationQueries.getWSSchema(org1Users[4])));
    }

    @Test
    public void testMultiLevelImpersonationExceedsMaxUserHops() throws Exception {
        UserRemoteException ex = null;
        try {
            TestImpersonationQueries.updateClient(org1Users[5]);
            TestImpersonationQueries.test(String.format("SELECT * from %s.u4_lineitem LIMIT 1;", TestImpersonationQueries.getWSSchema(org1Users[4])));
        }
        catch (UserRemoteException e) {
            ex = e;
        }
        Assert.assertNotNull((String)"UserRemoteException is expected", (Object)((Object)ex));
        Assert.assertThat((Object)ex.getMessage(), (Matcher)StringContains.containsString((String)"Cannot issue token for view expansion as issuing the token exceeds the maximum allowed number of user hops (3) in chained impersonation"));
    }

    @Test
    public void testMultiLevelImpersonationJoinEachSideReachesMaxUserHops() throws Exception {
        TestImpersonationQueries.updateClient(org1Users[4]);
        TestImpersonationQueries.test(String.format("SELECT * from %s.u4_lineitem l JOIN %s.u3_orders o ON l.l_orderkey = o.o_orderkey LIMIT 1;", TestImpersonationQueries.getWSSchema(org1Users[4]), TestImpersonationQueries.getWSSchema(org2Users[3])));
    }

    @Test
    public void testMultiLevelImpersonationJoinOneSideExceedsMaxUserHops() throws Exception {
        UserRemoteException ex = null;
        try {
            TestImpersonationQueries.updateClient(org1Users[4]);
            TestImpersonationQueries.test(String.format("SELECT * from %s.u4_lineitem l JOIN %s.u4_orders o ON l.l_orderkey = o.o_orderkey LIMIT 1;", TestImpersonationQueries.getWSSchema(org1Users[4]), TestImpersonationQueries.getWSSchema(org2Users[4])));
        }
        catch (UserRemoteException e) {
            ex = e;
        }
        Assert.assertNotNull((String)"UserRemoteException is expected", (Object)((Object)ex));
        Assert.assertThat((Object)ex.getMessage(), (Matcher)StringContains.containsString((String)"Cannot issue token for view expansion as issuing the token exceeds the maximum allowed number of user hops (3) in chained impersonation"));
    }

    @AfterClass
    public static void removeMiniDfsBasedStorage() throws Exception {
        TestImpersonationQueries.getDrillbitContext().getStorage().deletePlugin("miniDfsPlugin");
        TestImpersonationQueries.stopMiniDfsCluster();
    }
}

