/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.impersonation;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.exec.impersonation.BaseTestImpersonation;
import org.apache.drill.exec.store.dfs.WorkspaceConfig;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestImpersonationMetadata
extends BaseTestImpersonation {
    private static final String user1 = "drillTestUser1";
    private static final String user2 = "drillTestUser2";
    private static final String group0 = "drillTestGrp0";
    private static final String group1 = "drillTestGrp1";

    @BeforeClass
    public static void setup() throws Exception {
        TestImpersonationMetadata.startMiniDfsCluster(TestImpersonationMetadata.class.getSimpleName());
        TestImpersonationMetadata.startDrillCluster(true);
        TestImpersonationMetadata.addMiniDfsBasedStorage(TestImpersonationMetadata.createTestWorkspaces());
    }

    private static Map<String, WorkspaceConfig> createTestWorkspaces() throws Exception {
        Path tmpPath = new Path("/tmp");
        fs.delete(tmpPath, true);
        FileSystem.mkdirs((FileSystem)fs, (Path)tmpPath, (FsPermission)new FsPermission(511));
        HashMap workspaces = Maps.newHashMap();
        TestImpersonationMetadata.createAndAddWorkspace("drillTestGrp0_700", "/drillTestGrp0_700", (short)448, processUser, group0, workspaces);
        TestImpersonationMetadata.createAndAddWorkspace("drillTestGrp0_750", "/drillTestGrp0_750", (short)488, processUser, group0, workspaces);
        TestImpersonationMetadata.createAndAddWorkspace("drillTestGrp0_755", "/drillTestGrp0_755", (short)493, processUser, group0, workspaces);
        TestImpersonationMetadata.createAndAddWorkspace("drillTestGrp0_770", "/drillTestGrp0_770", (short)504, processUser, group0, workspaces);
        TestImpersonationMetadata.createAndAddWorkspace("drillTestGrp0_777", "/drillTestGrp0_777", (short)511, processUser, group0, workspaces);
        TestImpersonationMetadata.createAndAddWorkspace("drillTestGrp1_700", "/drillTestGrp1_700", (short)448, user1, group1, workspaces);
        TestImpersonationMetadata.createAndAddWorkspace("user2_workspace1", "/user2_workspace1", (short)509, user2, group1, workspaces);
        TestImpersonationMetadata.createAndAddWorkspace("user2_workspace2", "/user2_workspace2", (short)493, user2, group1, workspaces);
        return workspaces;
    }

    @Test
    public void testDropTable() throws Exception {
        TestImpersonationMetadata.updateClient(user2);
        TestImpersonationMetadata.test(String.format("use `%s.user2_workspace1`", "miniDfsPlugin"));
        TestImpersonationMetadata.test("create table parquet_table_775 as select * from cp.`employee.json`");
        TestImpersonationMetadata.test(String.format("use `%s.user2_workspace2`", "miniDfsPlugin"));
        TestImpersonationMetadata.test("create table parquet_table_700 as select * from cp.`employee.json`");
        TestImpersonationMetadata.updateClient(user1);
        TestImpersonationMetadata.test(String.format("use `%s.user2_workspace1`", "miniDfsPlugin"));
        TestImpersonationMetadata.testBuilder().sqlQuery("drop table parquet_table_775").unOrdered().baselineColumns("ok", "summary").baselineValues(true, String.format("Table [%s] dropped", "parquet_table_775")).go();
        TestImpersonationMetadata.test(String.format("use `%s.user2_workspace2`", "miniDfsPlugin"));
        boolean dropFailed = false;
        try {
            TestImpersonationMetadata.test("drop table parquet_table_700");
        }
        catch (UserException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("PERMISSION ERROR"));
            dropFailed = true;
        }
        Assert.assertTrue((String)"Permission checking failed during drop table", (boolean)dropFailed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImpersonatingProcessUser() throws Exception {
        TestImpersonationMetadata.updateClient(processUser);
        String viewName = String.format("%s.drillTestGrp0_700.testView", "miniDfsPlugin");
        try {
            TestImpersonationMetadata.test("CREATE VIEW " + viewName + " AS SELECT * FROM cp.`region.json`");
            TestImpersonationMetadata.test("SELECT * FROM " + viewName + " LIMIT 2");
        }
        finally {
            TestImpersonationMetadata.test("DROP VIEW " + viewName);
        }
    }

    @Test
    public void testShowFilesInWSWithUserAndGroupPermissionsForQueryUser() throws Exception {
        TestImpersonationMetadata.updateClient(user1);
        TestImpersonationMetadata.test(String.format("SHOW FILES IN %s.drillTestGrp1_700", "miniDfsPlugin"));
        TestImpersonationMetadata.test(String.format("SHOW FILES IN %s.drillTestGrp0_750", "miniDfsPlugin"));
    }

    @Test
    public void testShowFilesInWSWithOtherPermissionsForQueryUser() throws Exception {
        TestImpersonationMetadata.updateClient(user2);
        TestImpersonationMetadata.test(String.format("SHOW FILES IN %s.drillTestGrp0_755", "miniDfsPlugin"));
    }

    @Test
    public void testShowFilesInWSWithNoPermissionsForQueryUser() throws Exception {
        UserRemoteException ex = null;
        TestImpersonationMetadata.updateClient(user2);
        try {
            TestImpersonationMetadata.test(String.format("SHOW FILES IN %s.drillTestGrp1_700", "miniDfsPlugin"));
        }
        catch (UserRemoteException e) {
            ex = e;
        }
        Assert.assertNotNull((String)"UserRemoteException is expected", (Object)((Object)ex));
        Assert.assertThat((Object)ex.getMessage(), (Matcher)StringContains.containsString((String)"Permission denied: user=drillTestUser2, access=READ_EXECUTE, inode=\"/drillTestGrp1_700\":drillTestUser1:drillTestGrp1:drwx------"));
    }

    @Test
    public void testShowSchemasAsUser1() throws Exception {
        TestImpersonationMetadata.updateClient(user1);
        TestImpersonationMetadata.testBuilder().sqlQuery("SHOW SCHEMAS LIKE '%drillTest%'").unOrdered().baselineColumns("SCHEMA_NAME").baselineValues(String.format("%s.drillTestGrp0_750", "miniDfsPlugin")).baselineValues(String.format("%s.drillTestGrp0_755", "miniDfsPlugin")).baselineValues(String.format("%s.drillTestGrp0_770", "miniDfsPlugin")).baselineValues(String.format("%s.drillTestGrp0_777", "miniDfsPlugin")).baselineValues(String.format("%s.drillTestGrp1_700", "miniDfsPlugin")).go();
    }

    @Test
    public void testShowSchemasAsUser2() throws Exception {
        TestImpersonationMetadata.updateClient(user2);
        TestImpersonationMetadata.testBuilder().sqlQuery("SHOW SCHEMAS LIKE '%drillTest%'").unOrdered().baselineColumns("SCHEMA_NAME").baselineValues(String.format("%s.drillTestGrp0_755", "miniDfsPlugin")).baselineValues(String.format("%s.drillTestGrp0_777", "miniDfsPlugin")).go();
    }

    @Test
    public void testCreateViewInDirWithUserPermissionsForQueryUser() throws Exception {
        String viewSchema = "miniDfsPlugin.drillTestGrp1_700";
        TestImpersonationMetadata.testCreateViewTestHelper(user1, "miniDfsPlugin.drillTestGrp1_700", "view1");
    }

    @Test
    public void testCreateViewInDirWithGroupPermissionsForQueryUser() throws Exception {
        String viewSchema = "miniDfsPlugin.drillTestGrp0_770";
        TestImpersonationMetadata.testCreateViewTestHelper(user1, "miniDfsPlugin.drillTestGrp0_770", "view1");
    }

    @Test
    public void testCreateViewInDirWithOtherPermissionsForQueryUser() throws Exception {
        String viewSchema = "miniDfsPlugin.drillTestGrp0_777";
        TestImpersonationMetadata.testCreateViewTestHelper(user2, "miniDfsPlugin.drillTestGrp0_777", "view1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testCreateViewTestHelper(String user, String viewSchema, String viewName) throws Exception {
        try {
            TestImpersonationMetadata.updateClient(user);
            TestImpersonationMetadata.test("USE " + viewSchema);
            TestImpersonationMetadata.test("CREATE VIEW " + viewName + " AS SELECT " + "c_custkey, c_nationkey FROM cp.`tpch/customer.parquet` ORDER BY c_custkey;");
            TestImpersonationMetadata.testBuilder().sqlQuery("SHOW TABLES").unOrdered().baselineColumns("TABLE_SCHEMA", "TABLE_NAME").baselineValues(viewSchema, viewName).go();
            TestImpersonationMetadata.test("SHOW FILES");
            TestImpersonationMetadata.testBuilder().sqlQuery("SELECT * FROM " + viewName + " LIMIT 1").ordered().baselineColumns("c_custkey", "c_nationkey").baselineValues(1, 15).go();
        }
        finally {
            TestImpersonationMetadata.test("DROP VIEW " + viewSchema + "." + viewName);
        }
    }

    @Test
    public void testCreateViewInWSWithNoPermissionsForQueryUser() throws Exception {
        String viewSchema = "miniDfsPlugin.drillTestGrp0_755";
        String viewName = "view1";
        TestImpersonationMetadata.updateClient(user2);
        TestImpersonationMetadata.test("USE miniDfsPlugin.drillTestGrp0_755");
        String query = "CREATE VIEW view1 AS SELECT c_custkey, c_nationkey FROM cp.`tpch/customer.parquet` ORDER BY c_custkey;";
        String expErrorMsg = "PERMISSION ERROR: Permission denied: user=drillTestUser2, access=WRITE, inode=\"/drillTestGrp0_755\"";
        TestImpersonationMetadata.errorMsgTestHelper("CREATE VIEW view1 AS SELECT c_custkey, c_nationkey FROM cp.`tpch/customer.parquet` ORDER BY c_custkey;", "PERMISSION ERROR: Permission denied: user=drillTestUser2, access=WRITE, inode=\"/drillTestGrp0_755\"");
        TestImpersonationMetadata.testBuilder().sqlQuery("SHOW TABLES").expectsEmptyResultSet().go();
        TestImpersonationMetadata.test("SHOW FILES");
    }

    @Test
    public void testCreateTableInDirWithUserPermissionsForQueryUser() throws Exception {
        String tableWS = "drillTestGrp1_700";
        TestImpersonationMetadata.testCreateTableTestHelper(user1, "drillTestGrp1_700", "table1");
    }

    @Test
    public void testCreateTableInDirWithGroupPermissionsForQueryUser() throws Exception {
        String tableWS = "drillTestGrp0_770";
        TestImpersonationMetadata.testCreateTableTestHelper(user1, "drillTestGrp0_770", "table1");
    }

    @Test
    public void testCreateTableInDirWithOtherPermissionsForQueryUser() throws Exception {
        String tableWS = "drillTestGrp0_777";
        TestImpersonationMetadata.testCreateTableTestHelper(user2, "drillTestGrp0_777", "table1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testCreateTableTestHelper(String user, String tableWS, String tableName) throws Exception {
        try {
            TestImpersonationMetadata.updateClient(user);
            TestImpersonationMetadata.test("USE " + Joiner.on((String)".").join((Object)"miniDfsPlugin", (Object)tableWS, new Object[0]));
            TestImpersonationMetadata.test("CREATE TABLE " + tableName + " AS SELECT " + "c_custkey, c_nationkey FROM cp.`tpch/customer.parquet` ORDER BY c_custkey;");
            TestImpersonationMetadata.test("SHOW FILES");
            TestImpersonationMetadata.testBuilder().sqlQuery("SELECT * FROM " + tableName + " LIMIT 1").ordered().baselineColumns("c_custkey", "c_nationkey").baselineValues(1, 15).go();
        }
        finally {
            Path tablePath = new Path("/" + tableWS + "/" + tableName);
            if (fs.exists(tablePath)) {
                fs.delete(tablePath, true);
            }
        }
    }

    @Test
    public void testCreateTableInWSWithNoPermissionsForQueryUser() throws Exception {
        String tableWS = "drillTestGrp0_755";
        String tableName = "table1";
        UserRemoteException ex = null;
        try {
            TestImpersonationMetadata.updateClient(user2);
            TestImpersonationMetadata.test("USE " + Joiner.on((String)".").join((Object)"miniDfsPlugin", (Object)"drillTestGrp0_755", new Object[0]));
            TestImpersonationMetadata.test("CREATE TABLE table1 AS SELECT c_custkey, c_nationkey FROM cp.`tpch/customer.parquet` ORDER BY c_custkey;");
        }
        catch (UserRemoteException e) {
            ex = e;
        }
        Assert.assertNotNull((String)"UserRemoteException is expected", (Object)((Object)ex));
        Assert.assertThat((Object)ex.getMessage(), (Matcher)StringContains.containsString((String)"Permission denied: user=drillTestUser2, access=WRITE, inode=\"/drillTestGrp0_755\""));
    }

    @AfterClass
    public static void removeMiniDfsBasedStorage() throws Exception {
        TestImpersonationMetadata.getDrillbitContext().getStorage().deletePlugin("miniDfsPlugin");
        TestImpersonationMetadata.stopMiniDfsCluster();
    }

    static {
        UserGroupInformation.createUserForTesting((String)user1, (String[])new String[]{group1, group0});
        UserGroupInformation.createUserForTesting((String)user2, (String[])new String[]{group1});
    }
}

