/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.impersonation;

import com.google.common.collect.Maps;
import org.apache.drill.exec.impersonation.BaseTestImpersonation;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestImpersonationDisabledWithMiniDFS
extends BaseTestImpersonation {
    @BeforeClass
    public static void setup() throws Exception {
        TestImpersonationDisabledWithMiniDFS.startMiniDfsCluster(TestImpersonationDisabledWithMiniDFS.class.getSimpleName(), false);
        TestImpersonationDisabledWithMiniDFS.startDrillCluster(false);
        TestImpersonationDisabledWithMiniDFS.addMiniDfsBasedStorage(Maps.newHashMap());
        TestImpersonationDisabledWithMiniDFS.createTestData();
    }

    private static void createTestData() throws Exception {
        TestImpersonationDisabledWithMiniDFS.test(String.format("CREATE TABLE %s.tmp.dfsRegion AS SELECT * FROM cp.`region.json`", "miniDfsPlugin"));
    }

    @Test
    public void testSimpleQuery() throws Exception {
        String query = String.format("SELECT sales_city, sales_country FROM tmp.dfsRegion ORDER BY region_id DESC LIMIT 2", new Object[0]);
        TestImpersonationDisabledWithMiniDFS.testBuilder().optionSettingQueriesForTestQuery(String.format("USE %s", "miniDfsPlugin")).sqlQuery(query).unOrdered().baselineColumns("sales_city", "sales_country").baselineValues("Santa Fe", "Mexico").baselineValues("Santa Anita", "Mexico").go();
    }

    @AfterClass
    public static void removeMiniDfsBasedStorage() throws Exception {
        TestImpersonationDisabledWithMiniDFS.getDrillbitContext().getStorage().deletePlugin("miniDfsPlugin");
        TestImpersonationDisabledWithMiniDFS.stopMiniDfsCluster();
    }
}

