/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.impersonation;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.drill.PlanTestBase;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.dfs.FileSystemConfig;
import org.apache.drill.exec.store.dfs.WorkspaceConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;

public class BaseTestImpersonation
extends PlanTestBase {
    protected static final String MINIDFS_STORAGE_PLUGIN_NAME = "miniDfsPlugin";
    protected static final String processUser;
    protected static MiniDFSCluster dfsCluster;
    protected static Configuration dfsConf;
    protected static FileSystem fs;
    protected static String miniDfsStoragePath;
    protected static final String[] org1Users;
    protected static final String[] org1Groups;
    protected static final String[] org2Users;
    protected static final String[] org2Groups;

    protected static void startMiniDfsCluster(String testClass) throws Exception {
        BaseTestImpersonation.startMiniDfsCluster(testClass, true);
    }

    protected static void startMiniDfsCluster(String testClass, boolean isImpersonationEnabled) throws Exception {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)testClass) ? 1 : 0) != 0, (Object)"Expected a non-null and non-empty test class name");
        dfsConf = new Configuration();
        miniDfsStoragePath = System.getProperty("java.io.tmpdir") + "/" + testClass;
        dfsConf.set("hdfs.minidfs.basedir", miniDfsStoragePath);
        if (isImpersonationEnabled) {
            dfsConf.set(String.format("hadoop.proxyuser.%s.hosts", processUser), "*");
            dfsConf.set(String.format("hadoop.proxyuser.%s.groups", processUser), "*");
        }
        dfsCluster = new MiniDFSCluster.Builder(dfsConf).numDataNodes(3).format(true).build();
        fs = dfsCluster.getFileSystem();
    }

    protected static void startDrillCluster(boolean isImpersonationEnabled) throws Exception {
        Properties props = BaseTestImpersonation.cloneDefaultTestConfigProperties();
        props.setProperty("drill.exec.impersonation.enabled", Boolean.toString(isImpersonationEnabled));
        BaseTestImpersonation.updateTestCluster(1, DrillConfig.create((Properties)props));
    }

    protected static void addMiniDfsBasedStorage(Map<String, WorkspaceConfig> workspaces) throws Exception {
        StoragePluginRegistry pluginRegistry = BaseTestImpersonation.getDrillbitContext().getStorage();
        FileSystemConfig lfsPluginConfig = (FileSystemConfig)pluginRegistry.getPlugin("dfs_test").getConfig();
        FileSystemConfig miniDfsPluginConfig = new FileSystemConfig();
        miniDfsPluginConfig.connection = dfsConf.get("fs.defaultFS");
        BaseTestImpersonation.createAndAddWorkspace("tmp", "/tmp", (short)511, processUser, processUser, workspaces);
        miniDfsPluginConfig.workspaces = workspaces;
        miniDfsPluginConfig.formats = ImmutableMap.copyOf((Map)lfsPluginConfig.formats);
        miniDfsPluginConfig.setEnabled(true);
        pluginRegistry.createOrUpdate(MINIDFS_STORAGE_PLUGIN_NAME, (StoragePluginConfig)miniDfsPluginConfig, true);
    }

    protected static void createAndAddWorkspace(String name, String path, short permissions, String owner, String group, Map<String, WorkspaceConfig> workspaces) throws Exception {
        Path dirPath = new Path(path);
        FileSystem.mkdirs((FileSystem)fs, (Path)dirPath, (FsPermission)new FsPermission(permissions));
        fs.setOwner(dirPath, owner, group);
        WorkspaceConfig ws = new WorkspaceConfig(path, true, "parquet");
        workspaces.put(name, ws);
    }

    protected static void stopMiniDfsCluster() throws Exception {
        if (dfsCluster != null) {
            dfsCluster.shutdown();
            dfsCluster = null;
        }
        if (miniDfsStoragePath != null) {
            FileUtils.deleteQuietly((File)new File(miniDfsStoragePath));
        }
    }

    static {
        int i;
        processUser = System.getProperty("user.name");
        org1Users = new String[]{"user0_1", "user1_1", "user2_1", "user3_1", "user4_1", "user5_1"};
        org1Groups = new String[]{"group0_1", "group1_1", "group2_1", "group3_1", "group4_1", "group5_1"};
        org2Users = new String[]{"user0_2", "user1_2", "user2_2", "user3_2", "user4_2", "user5_2"};
        org2Groups = new String[]{"group0_2", "group1_2", "group2_2", "group3_2", "group4_2", "group5_2"};
        UserGroupInformation.createUserForTesting((String)org1Users[0], (String[])new String[]{org1Groups[0]});
        for (i = 1; i < org1Users.length; ++i) {
            UserGroupInformation.createUserForTesting((String)org1Users[i], (String[])new String[]{org1Groups[i], org1Groups[i - 1]});
        }
        UserGroupInformation.createUserForTesting((String)org2Users[0], (String[])new String[]{org2Groups[0]});
        for (i = 1; i < org2Users.length; ++i) {
            UserGroupInformation.createUserForTesting((String)org2Users[i], (String[])new String[]{org2Groups[i], org2Groups[i - 1]});
        }
    }
}

