/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.fn.interp;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.ErrorCollector;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.parser.ExprLexer;
import org.apache.drill.common.expression.parser.ExprParser;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.expr.fn.FunctionLookupContext;
import org.apache.drill.exec.expr.fn.impl.DateUtility;
import org.apache.drill.exec.expr.fn.interpreter.InterpreterEvaluator;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.store.mock.MockGroupScanPOP;
import org.apache.drill.exec.store.mock.MockScanBatchCreator;
import org.apache.drill.exec.store.mock.MockSubScanPOP;
import org.apache.drill.exec.vector.ValueVector;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionInterpreterTest
extends PopUnitTestBase {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionInterpreterTest.class);

    @Test
    public void interpreterNullableStrExpr() throws Exception {
        String[] colNames = new String[]{"col1"};
        TypeProtos.MajorType[] colTypes = new TypeProtos.MajorType[]{Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR)};
        String expressionStr = "substr(col1, 1, 3)";
        String[] expectedFirstTwoValues = new String[]{"aaa", "null"};
        this.doTest("substr(col1, 1, 3)", colNames, colTypes, expectedFirstTwoValues);
    }

    @Test
    public void interpreterNullableBooleanExpr() throws Exception {
        String[] colNames = new String[]{"col1"};
        TypeProtos.MajorType[] colTypes = new TypeProtos.MajorType[]{Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR)};
        String expressionStr = "col1 < 'abc' and col1 > 'abc'";
        String[] expectedFirstTwoValues = new String[]{"false", "null"};
        this.doTest("col1 < 'abc' and col1 > 'abc'", colNames, colTypes, expectedFirstTwoValues);
    }

    @Test
    public void interpreterNullableIntegerExpr() throws Exception {
        String[] colNames = new String[]{"col1"};
        TypeProtos.MajorType[] colTypes = new TypeProtos.MajorType[]{Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.INT)};
        String expressionStr = "col1 + 100 - 1 * 2 + 2";
        String[] expectedFirstTwoValues = new String[]{"-2147483548", "null"};
        this.doTest("col1 + 100 - 1 * 2 + 2", colNames, colTypes, expectedFirstTwoValues);
    }

    @Test
    public void interpreterLikeExpr() throws Exception {
        String[] colNames = new String[]{"col1"};
        TypeProtos.MajorType[] colTypes = new TypeProtos.MajorType[]{Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR)};
        String expressionStr = "like(col1, 'aaa%')";
        String[] expectedFirstTwoValues = new String[]{"true", "null"};
        this.doTest("like(col1, 'aaa%')", colNames, colTypes, expectedFirstTwoValues);
    }

    @Test
    public void interpreterCastExpr() throws Exception {
        String[] colNames = new String[]{"col1"};
        TypeProtos.MajorType[] colTypes = new TypeProtos.MajorType[]{Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR)};
        String expressionStr = "cast(3+4 as float8)";
        String[] expectedFirstTwoValues = new String[]{"7.0", "7.0"};
        this.doTest("cast(3+4 as float8)", colNames, colTypes, expectedFirstTwoValues);
    }

    @Test
    public void interpreterCaseExpr() throws Exception {
        String[] colNames = new String[]{"col1"};
        TypeProtos.MajorType[] colTypes = new TypeProtos.MajorType[]{Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR)};
        String expressionStr = "case when substr(col1, 1, 3)='aaa' then 'ABC' else 'XYZ' end";
        String[] expectedFirstTwoValues = new String[]{"ABC", "XYZ"};
        this.doTest("case when substr(col1, 1, 3)='aaa' then 'ABC' else 'XYZ' end", colNames, colTypes, expectedFirstTwoValues);
    }

    @Test
    public void interpreterDateTest() throws Exception {
        String[] colNames = new String[]{"col1"};
        TypeProtos.MajorType[] colTypes = new TypeProtos.MajorType[]{Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.INT)};
        String expressionStr = "now()";
        BitControl.PlanFragment planFragment = BitControl.PlanFragment.getDefaultInstance();
        BitControl.QueryContextInformation queryContextInfo = planFragment.getContext();
        int timeZoneIndex = queryContextInfo.getTimeZone();
        DateTimeZone timeZone = DateTimeZone.forID((String)DateUtility.getTimeZone((int)timeZoneIndex));
        DateTime now = new DateTime(queryContextInfo.getQueryStartTime(), timeZone);
        long queryStartDate = now.getMillis();
        TimeStampHolder out = new TimeStampHolder();
        out.value = queryStartDate;
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.putLong(out.value);
        long l = buffer.getLong(0);
        DateTime t = new DateTime(l);
        String[] expectedFirstTwoValues = new String[]{t.toString(), t.toString()};
        this.doTest("now()", colNames, colTypes, expectedFirstTwoValues, planFragment);
    }

    protected void doTest(String expressionStr, String[] colNames, TypeProtos.MajorType[] colTypes, String[] expectFirstTwoValues) throws Exception {
        this.doTest(expressionStr, colNames, colTypes, expectFirstTwoValues, BitControl.PlanFragment.getDefaultInstance());
    }

    protected void doTest(String expressionStr, String[] colNames, TypeProtos.MajorType[] colTypes, String[] expectFirstTwoValues, BitControl.PlanFragment planFragment) throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
        bit1.run();
        Assert.assertEquals((long)colNames.length, (long)colTypes.length);
        MockGroupScanPOP.MockColumn[] columns = new MockGroupScanPOP.MockColumn[colNames.length];
        for (int i = 0; i < colNames.length; ++i) {
            columns[i] = new MockGroupScanPOP.MockColumn(colNames[i], colTypes[i].getMinorType(), colTypes[i].getMode(), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
        }
        MockGroupScanPOP.MockScanEntry entry = new MockGroupScanPOP.MockScanEntry(10, columns);
        MockSubScanPOP scanPOP = new MockSubScanPOP("testTable", Collections.singletonList(entry));
        ScanBatch batch = this.createMockScanBatch(bit1, scanPOP, planFragment);
        batch.next();
        ValueVector vv = this.evalExprWithInterpreter(expressionStr, (RecordBatch)batch, bit1);
        Assert.assertEquals((long)2L, (long)expectFirstTwoValues.length);
        Assert.assertEquals((Object)expectFirstTwoValues[0], (Object)this.getValueFromVector(vv, 0));
        Assert.assertEquals((Object)expectFirstTwoValues[1], (Object)this.getValueFromVector(vv, 1));
        this.showValueVectorContent(vv);
        vv.clear();
        batch.close();
        batch.getContext().close();
        bit1.close();
    }

    private ScanBatch createMockScanBatch(Drillbit bit, MockSubScanPOP scanPOP, BitControl.PlanFragment planFragment) {
        ArrayList children = Lists.newArrayList();
        MockScanBatchCreator creator = new MockScanBatchCreator();
        try {
            FragmentContext context = new FragmentContext(bit.getContext(), planFragment, null, bit.getContext().getFunctionImplementationRegistry());
            return creator.getBatch(context, scanPOP, (List)children);
        }
        catch (Exception ex) {
            throw new DrillRuntimeException("Error when setup fragment context" + ex);
        }
    }

    private LogicalExpression parseExpr(String expr) throws RecognitionException {
        ExprLexer lexer = new ExprLexer((CharStream)new ANTLRStringStream(expr));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ExprParser parser = new ExprParser((TokenStream)tokens);
        ExprParser.parse_return ret = parser.parse();
        return ret.e;
    }

    private ValueVector evalExprWithInterpreter(String expression, RecordBatch batch, Drillbit bit) throws Exception {
        LogicalExpression expr = this.parseExpr(expression);
        ErrorCollectorImpl error = new ErrorCollectorImpl();
        LogicalExpression materializedExpr = ExpressionTreeMaterializer.materialize((LogicalExpression)expr, (VectorAccessible)batch, (ErrorCollector)error, (FunctionLookupContext)bit.getContext().getFunctionImplementationRegistry());
        if (error.getErrorCount() != 0) {
            logger.error("Failure while materializing expression [{}].  Errors: {}", (Object)expression, (Object)error);
            Assert.assertEquals((long)0L, (long)error.getErrorCount());
        }
        MaterializedField outputField = MaterializedField.create((String)"outCol", (TypeProtos.MajorType)materializedExpr.getMajorType());
        ValueVector vector = TypeHelper.getNewVector(outputField, bit.getContext().getAllocator());
        vector.allocateNewSafe();
        InterpreterEvaluator.evaluate((RecordBatch)batch, (ValueVector)vector, (LogicalExpression)materializedExpr);
        return vector;
    }

    private void showValueVectorContent(ValueVector vw) {
        for (int row = 0; row < vw.getAccessor().getValueCount(); ++row) {
            Object o = vw.getAccessor().getObject(row);
            String cellString = o instanceof byte[] ? DrillStringUtils.toBinaryString((byte[])((byte[])o)) : DrillStringUtils.escapeNewLines((String)String.valueOf(o));
            System.out.printf(row + "th value: " + cellString + "\n", new Object[0]);
        }
    }

    private String getValueFromVector(ValueVector vw, int index) {
        Object o = vw.getAccessor().getObject(index);
        String cellString = o instanceof byte[] ? DrillStringUtils.toBinaryString((byte[])((byte[])o)) : DrillStringUtils.escapeNewLines((String)String.valueOf(o));
        return cellString;
    }
}

