/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.fn.impl;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import mockit.Injectable;
import mockit.NonStrictExpectations;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.compile.CodeCompiler;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import org.apache.drill.exec.physical.impl.SimpleRootExec;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.vector.BitVector;
import org.apache.drill.exec.vector.IntVector;
import org.junit.Assert;
import org.junit.Test;

public class TestRepeatedFunction
extends ExecTest {
    private final DrillConfig c = DrillConfig.create();

    @Test
    public void testRepeated(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestRepeatedFunction.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestRepeatedFunction.this.c);
                bitContext.getConfig();
                result = TestRepeatedFunction.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestRepeatedFunction.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/physical_repeated_1.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        boolean oneIsOne = false;
        int size = 0;
        int[] sizes = new int[]{1, 2, 0, 6};
        while (exec.next()) {
            IntVector c1 = (IntVector)((Object)exec.getValueVectorById(new SchemaPath("cnt", ExpressionPosition.UNKNOWN), IntVector.class));
            BitVector c2 = (BitVector)exec.getValueVectorById(new SchemaPath("has_min", ExpressionPosition.UNKNOWN), BitVector.class);
            for (int i = 0; i < exec.getRecordCount(); ++i) {
                int curSize = sizes[size % sizes.length];
                Assert.assertEquals((long)curSize, (long)c1.getAccessor().get(i));
                switch (curSize) {
                    case 1: {
                        Assert.assertEquals((Object)oneIsOne, (Object)(1 == c2.getAccessor().get(i) ? 1 : 0));
                        oneIsOne = !oneIsOne;
                        break;
                    }
                    case 2: {
                        Assert.assertEquals((long)1L, (long)c2.getAccessor().get(i));
                        break;
                    }
                    case 0: {
                        Assert.assertEquals((long)0L, (long)c2.getAccessor().get(i));
                        break;
                    }
                    case 6: {
                        Assert.assertEquals((long)1L, (long)c2.getAccessor().get(i));
                    }
                }
                ++size;
            }
        }
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }
}

