/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.fn.impl;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import mockit.Injectable;
import mockit.NonStrictExpectations;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.compile.CodeCompiler;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import org.apache.drill.exec.physical.impl.SimpleRootExec;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.junit.Assert;
import org.junit.Test;

public class TestNewMathFunctions {
    private final DrillConfig c = DrillConfig.create();
    private PhysicalPlanReader reader;
    private FunctionImplementationRegistry registry;
    private FragmentContext context;

    public Object[] getRunResult(SimpleRootExec exec) {
        int size = 0;
        for (ValueVector v : exec) {
            ++size;
        }
        Object[] res = new Object[size];
        int i = 0;
        for (ValueVector v : exec) {
            if (v instanceof VarCharVector) {
                res[i++] = new String(((VarCharVector)v).getAccessor().get(0));
                continue;
            }
            res[i++] = v.getAccessor().getObject(0);
        }
        return res;
    }

    public void runTest(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection, Object[] expectedResults, String planPath) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestNewMathFunctions.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestNewMathFunctions.this.c);
                bitContext.getConfig();
                result = TestNewMathFunctions.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestNewMathFunctions.this.c);
            }
        };
        String planString = Resources.toString((URL)Resources.getResource((String)planPath), (Charset)Charsets.UTF_8);
        if (this.reader == null) {
            this.reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        }
        if (this.registry == null) {
            this.registry = new FunctionImplementationRegistry(this.c);
        }
        if (this.context == null) {
            this.context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, this.registry);
        }
        PhysicalPlan plan = this.reader.readPhysicalPlan(planString);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)this.context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        exec.next();
        while (exec.next()) {
            Object[] res = this.getRunResult(exec);
            Assert.assertEquals((String)"return count does not match", (long)expectedResults.length, (long)res.length);
            for (int i = 0; i < res.length; ++i) {
                Assert.assertEquals((String)String.format("column %s does not match", i), (Object)res[i], (Object)expectedResults[i]);
            }
        }
        if (this.context.getFailureCause() != null) {
            throw this.context.getFailureCause();
        }
        Assert.assertTrue((!this.context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void testTrigoMathFunc(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{Math.sin(45.0), Math.cos(45.0), Math.tan(45.0), Math.asin(45.0), Math.acos(45.0), Math.atan(45.0), Math.sinh(45.0), Math.cosh(45.0), Math.tanh(45.0)};
        this.runTest(bitContext, connection, expected, "functions/testTrigoMathFunctions.json");
    }

    @Test
    public void testExtendedMathFunc(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        BigDecimal d = new BigDecimal("100111111111111111111111111111111111.00000000000000000000000000000000000000000000000000001");
        Object[] expected = new Object[]{Math.cbrt(1000.0), Math.log(10.0), Math.log(64.0) / Math.log(2.0), Math.exp(10.0), Math.toDegrees(0.5), Math.toRadians(45.0), Math.PI, Math.cbrt(d.doubleValue()), Math.log(d.doubleValue()), Math.log(d.doubleValue()) / Math.log(2.0), Math.exp(d.doubleValue()), Math.toDegrees(d.doubleValue()), Math.toRadians(d.doubleValue())};
        this.runTest(bitContext, connection, expected, "functions/testExtendedMathFunctions.json");
    }

    @Test
    public void testTruncDivMod(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{101.0, 0, 101, 1010.0, 101, 481.0, 0.001099999999931267};
        this.runTest(bitContext, connection, expected, "functions/testDivModTruncFunctions.json");
    }

    @Test
    public void testIsNumeric(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        Object[] expected = new Object[]{1, 1, 1, 0};
        this.runTest(bitContext, connection, expected, "functions/testIsNumericFunction.json");
    }
}

