/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.fn.impl;

import org.apache.drill.BaseTestQuery;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Test;

public class TestNewDateFunctions
extends BaseTestQuery {
    DateTime date;
    DateTimeFormatter formatter;
    long unixTimeStamp = -1L;

    @Test
    public void testUnixTimeStampForDate() throws Exception {
        this.formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        this.date = this.formatter.parseDateTime("2009-03-20 11:30:01");
        this.unixTimeStamp = this.date.getMillis() / 1000L;
        TestNewDateFunctions.testBuilder().sqlQuery("select unix_timestamp('2009-03-20 11:30:01') from cp.`employee.json` limit 1").ordered().baselineColumns("EXPR$0").baselineValues(this.unixTimeStamp).build().run();
        this.date = this.formatter.parseDateTime("2014-08-09 05:15:06");
        this.unixTimeStamp = this.date.getMillis() / 1000L;
        TestNewDateFunctions.testBuilder().sqlQuery("select unix_timestamp('2014-08-09 05:15:06') from cp.`employee.json` limit 1").ordered().baselineColumns("EXPR$0").baselineValues(this.unixTimeStamp).build().run();
        this.date = this.formatter.parseDateTime("1970-01-01 00:00:00");
        this.unixTimeStamp = this.date.getMillis() / 1000L;
        TestNewDateFunctions.testBuilder().sqlQuery("select unix_timestamp('1970-01-01 00:00:00') from cp.`employee.json` limit 1").ordered().baselineColumns("EXPR$0").baselineValues(this.unixTimeStamp).build().run();
    }

    @Test
    public void testUnixTimeStampForDateWithPattern() throws Exception {
        this.formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS");
        this.date = this.formatter.parseDateTime("2009-03-20 11:30:01.0");
        this.unixTimeStamp = this.date.getMillis() / 1000L;
        TestNewDateFunctions.testBuilder().sqlQuery("select unix_timestamp('2009-03-20 11:30:01.0', 'yyyy-MM-dd HH:mm:ss.SSS') from cp.`employee.json` limit 1").ordered().baselineColumns("EXPR$0").baselineValues(this.unixTimeStamp).build().run();
        this.formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        this.date = this.formatter.parseDateTime("2009-03-20");
        this.unixTimeStamp = this.date.getMillis() / 1000L;
        TestNewDateFunctions.testBuilder().sqlQuery("select unix_timestamp('2009-03-20', 'yyyy-MM-dd') from cp.`employee.json` limit 1").ordered().baselineColumns("EXPR$0").baselineValues(this.unixTimeStamp).build().run();
    }

    @Test
    public void testCurrentDate() throws Exception {
        TestNewDateFunctions.testBuilder().sqlQuery("select (extract(hour from current_date) = 0) as col from cp.`employee.json` limit 1").unOrdered().baselineColumns("col").baselineValues(true).go();
    }

    @Test
    public void testLocalTimestamp() throws Exception {
        TestNewDateFunctions.testBuilder().sqlQuery("select extract(day from localtimestamp) = extract(day from current_date) as col from cp.`employee.json` limit 1").unOrdered().baselineColumns("col").baselineValues(true).go();
    }
}

