/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.fn.impl;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Assert;
import org.junit.Test;

public class TestNewAggregateFunctions
extends PopUnitTestBase {
    public void runTest(String physicalPlan, String inputDataFile, Object[] expected) throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)physicalPlan), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", inputDataFile));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(1);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            int i = 0;
            for (VectorWrapper v : batchLoader) {
                ValueVector.Accessor accessor = v.getValueVector().getAccessor();
                System.out.println(accessor.getObject(0));
                Assert.assertEquals((Object)expected[i++], (Object)accessor.getObject(0));
            }
            batchLoader.clear();
            for (QueryDataBatch b : results) {
                b.release();
            }
        }
    }

    @Test
    public void testBitwiseAggrFuncs() throws Exception {
        String physicalPlan = "/functions/test_logical_aggr.json";
        String inputDataFile = "/logical_aggr_input.json";
        Object[] expected = new Object[]{0L, 4L, 4L, 7L, -2L, 1L, true, false};
        this.runTest(physicalPlan, inputDataFile, expected);
    }
}

