/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.fn.impl;

import org.apache.drill.BaseTestQuery;
import org.junit.Test;

public class TestContextFunctions
extends BaseTestQuery {
    @Test
    public void userUDFForAnonymousConnection() throws Exception {
        TestContextFunctions.updateClient("");
        TestContextFunctions.testBuilder().sqlQuery("select user, session_user, system_user from cp.`employee.json` limit 1").unOrdered().baselineColumns("user", "session_user", "system_user").baselineValues("anonymous", "anonymous", "anonymous").go();
    }

    @Test
    public void userUDFForNamedConnection() throws Exception {
        String testUserName = "testUser1";
        TestContextFunctions.updateClient("testUser1");
        TestContextFunctions.testBuilder().sqlQuery("select user, session_user, system_user from cp.`employee.json` limit 1").unOrdered().baselineColumns("user", "session_user", "system_user").baselineValues("testUser1", "testUser1", "testUser1").go();
    }

    @Test
    public void userUDFInFilterCondition() throws Exception {
        String testUserName = "testUser2";
        TestContextFunctions.updateClient("testUser2");
        String query = String.format("select employee_id from cp.`employee.json` where '%s' = user order by employee_id limit 1", "testUser2");
        TestContextFunctions.testBuilder().sqlQuery(query).unOrdered().baselineColumns("employee_id").baselineValues(1L).go();
    }

    @Test
    public void currentSchemaUDFWhenDefaultSchemaNotSet() throws Exception {
        TestContextFunctions.testBuilder().sqlQuery("select current_schema from cp.`employee.json` limit 1").unOrdered().baselineColumns("current_schema").baselineValues("").go();
    }

    @Test
    public void currentSchemaUDFWithSingleLevelDefaultSchema() throws Exception {
        TestContextFunctions.testBuilder().optionSettingQueriesForTestQuery("USE dfs_test").sqlQuery("select current_schema from cp.`employee.json` limit 1").unOrdered().baselineColumns("current_schema").baselineValues("dfs_test").go();
    }

    @Test
    public void currentSchemaUDFWithMultiLevelDefaultSchema() throws Exception {
        TestContextFunctions.testBuilder().optionSettingQueriesForTestQuery("USE dfs_test.tmp").sqlQuery("select current_schema from cp.`employee.json` limit 1").unOrdered().baselineColumns("current_schema").baselineValues("dfs_test.tmp").go();
    }
}

