/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.fn.impl;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.util.FileUtils;
import org.joda.time.Period;
import org.junit.Test;

public class TestCastFunctions
extends BaseTestQuery {
    @Test
    public void testVarbinaryToDate() throws Exception {
        TestCastFunctions.testBuilder().sqlQuery("select count(*) as cnt from cp.`employee.json` where (cast(convert_to(birth_date, 'utf8') as date)) = date '1961-08-26'").unOrdered().baselineColumns("cnt").baselineValues(1L).build().run();
    }

    @Test
    public void testImplicitCastStringToBoolean() throws Exception {
        String boolTable = FileUtils.getResourceAsFile((String)"/store/json/booleanData.json").toURI().toString();
        String query = String.format("(select * from dfs_test.`%s` where key = 'true' or key = 'false')", boolTable);
        TestCastFunctions.testBuilder().sqlQuery(query).unOrdered().baselineColumns("key").baselineValues(true).baselineValues(false).build().run();
    }

    @Test
    public void testCastTimesInterval() throws Exception {
        String query = "select cast(r_regionkey as Integer) * (INTERVAL '1' DAY) as col \nfrom cp.`tpch/region.parquet`";
        TestCastFunctions.testBuilder().sqlQuery("select cast(r_regionkey as Integer) * (INTERVAL '1' DAY) as col \nfrom cp.`tpch/region.parquet`").ordered().baselineColumns("col").baselineValues(Period.days((int)0)).baselineValues(Period.days((int)1)).baselineValues(Period.days((int)2)).baselineValues(Period.days((int)3)).baselineValues(Period.days((int)4)).build().run();
    }
}

