/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.fn.impl;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.util.FileUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestCastEmptyStrings
extends BaseTestQuery {
    @BeforeClass
    public static void enableDecimalDataType() throws Exception {
        TestCastEmptyStrings.test(String.format("alter session set `%s` = true", "planner.enable_decimal_data_type"));
    }

    @AfterClass
    public static void disableDecimalDataType() throws Exception {
        TestCastEmptyStrings.test(String.format("alter session set `%s` = false", "planner.enable_decimal_data_type"));
    }

    @Test
    public void testCastInputTypeNullableVarCharToNumeric() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/emptyStrings.csv").toURI().toString();
        TestCastEmptyStrings.test("alter system set `drill.exec.functions.cast_empty_string_to_null` = true;");
        TestCastEmptyStrings.test(String.format("select cast(columns[0] as int) from dfs_test.`%s`;", root));
        TestCastEmptyStrings.test(String.format("select cast(columns[0] as bigint) from dfs_test.`%s`;", root));
        TestCastEmptyStrings.test(String.format("select cast(columns[0] as float) from dfs_test.`%s`;", root));
        TestCastEmptyStrings.test(String.format("select cast(columns[0] as double) from dfs_test.`%s`;", root));
        TestCastEmptyStrings.test("alter system set `drill.exec.functions.cast_empty_string_to_null` = false;");
    }

    @Test
    public void testCastInputTypeNonNullableVarCharToNumeric() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/emptyStrings.csv").toURI().toString();
        TestCastEmptyStrings.test("alter system set `drill.exec.functions.cast_empty_string_to_null` = true;");
        TestCastEmptyStrings.test(String.format("select cast('' as int) from dfs_test.`%s`;", root));
        TestCastEmptyStrings.test(String.format("select cast('' as bigint) from dfs_test.`%s`;", root));
        TestCastEmptyStrings.test(String.format("select cast('' as float) from dfs_test.`%s`;", root));
        TestCastEmptyStrings.test(String.format("select cast('' as double) from dfs_test.`%s`;", root));
        TestCastEmptyStrings.test("alter system set `drill.exec.functions.cast_empty_string_to_null` = false;");
    }

    @Test
    public void testCastInputTypeNullableVarCharToDecimal() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/emptyStrings.csv").toURI().toString();
        TestCastEmptyStrings.test("alter system set `drill.exec.functions.cast_empty_string_to_null` = true;");
        TestCastEmptyStrings.test(String.format("select cast(columns[0] as decimal) from dfs_test.`%s` where cast(columns[0] as decimal) is null;", root));
        TestCastEmptyStrings.test(String.format("select cast(columns[0] as decimal(9)) from dfs_test.`%s`;", root));
        TestCastEmptyStrings.test(String.format("select cast(columns[0] as decimal(18)) from dfs_test.`%s`;", root));
        TestCastEmptyStrings.test(String.format("select cast(columns[0] as decimal(28)) from dfs_test.`%s`;", root));
        TestCastEmptyStrings.test(String.format("select cast(columns[0] as decimal(38)) from dfs_test.`%s`;", root));
        TestCastEmptyStrings.test("alter system set `drill.exec.functions.cast_empty_string_to_null` = false;");
    }

    @Test
    public void testCastInputTypeNonNullableVarCharToDecimal() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/emptyStrings.csv").toURI().toString();
        TestCastEmptyStrings.test("alter system set `drill.exec.functions.cast_empty_string_to_null` = true;");
        TestCastEmptyStrings.test(String.format("select cast('' as decimal) from dfs_test.`%s` where cast('' as decimal) is null;", root));
        TestCastEmptyStrings.test(String.format("select cast('' as decimal(18)) from dfs_test.`%s`;", root));
        TestCastEmptyStrings.test(String.format("select cast('' as decimal(28)) from dfs_test.`%s`;", root));
        TestCastEmptyStrings.test(String.format("select cast('' as decimal(38)) from dfs_test.`%s`;", root));
        TestCastEmptyStrings.test("alter system set `drill.exec.functions.cast_empty_string_to_null` = false;");
    }
}

