/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.fn.impl;

import io.netty.buffer.DrillBuf;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.vector.ValueHolderHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestByteComparisonFunctions
extends ExecTest {
    private static BufferAllocator allocator;
    private static VarCharHolder hello;
    private static VarCharHolder goodbye;
    private static VarCharHolder helloLong;
    private static VarCharHolder goodbyeLong;

    @BeforeClass
    public static void setup() {
        DrillConfig c = DrillConfig.create();
        allocator = RootAllocatorFactory.newRoot((DrillConfig)c);
        hello = ValueHolderHelper.getVarCharHolder((BufferAllocator)allocator, (String)"hello");
        goodbye = ValueHolderHelper.getVarCharHolder((BufferAllocator)allocator, (String)"goodbye");
        helloLong = ValueHolderHelper.getVarCharHolder((BufferAllocator)allocator, (String)"hellomyfriend");
        goodbyeLong = ValueHolderHelper.getVarCharHolder((BufferAllocator)allocator, (String)"goodbyemyenemy");
    }

    @AfterClass
    public static void teardown() {
        TestByteComparisonFunctions.hello.buffer.release();
        TestByteComparisonFunctions.helloLong.buffer.release();
        TestByteComparisonFunctions.goodbye.buffer.release();
        TestByteComparisonFunctions.goodbyeLong.buffer.release();
        allocator.close();
    }

    @Test
    public void testAfter() {
        VarCharHolder left = hello;
        VarCharHolder right = goodbye;
        Assert.assertTrue((ByteFunctionHelpers.compare((DrillBuf)left.buffer, (int)left.start, (int)left.end, (DrillBuf)right.buffer, (int)right.start, (int)right.end) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testBefore() {
        VarCharHolder left = goodbye;
        VarCharHolder right = hello;
        Assert.assertTrue((ByteFunctionHelpers.compare((DrillBuf)left.buffer, (int)left.start, (int)left.end, (DrillBuf)right.buffer, (int)right.start, (int)right.end) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualCompare() {
        VarCharHolder left = hello;
        VarCharHolder right = hello;
        Assert.assertTrue((ByteFunctionHelpers.compare((DrillBuf)left.buffer, (int)left.start, (int)left.end, (DrillBuf)right.buffer, (int)right.start, (int)right.end) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqual() {
        VarCharHolder left = hello;
        VarCharHolder right = hello;
        Assert.assertTrue((ByteFunctionHelpers.equal((DrillBuf)left.buffer, (int)left.start, (int)left.end, (DrillBuf)right.buffer, (int)right.start, (int)right.end) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testNotEqual() {
        VarCharHolder left = hello;
        VarCharHolder right = goodbye;
        Assert.assertTrue((ByteFunctionHelpers.equal((DrillBuf)left.buffer, (int)left.start, (int)left.end, (DrillBuf)right.buffer, (int)right.start, (int)right.end) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAfterLong() {
        VarCharHolder left = helloLong;
        VarCharHolder right = goodbyeLong;
        Assert.assertTrue((ByteFunctionHelpers.compare((DrillBuf)left.buffer, (int)left.start, (int)left.end, (DrillBuf)right.buffer, (int)right.start, (int)right.end) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testBeforeLong() {
        VarCharHolder left = goodbyeLong;
        VarCharHolder right = helloLong;
        Assert.assertTrue((ByteFunctionHelpers.compare((DrillBuf)left.buffer, (int)left.start, (int)left.end, (DrillBuf)right.buffer, (int)right.start, (int)right.end) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualCompareLong() {
        VarCharHolder left = helloLong;
        VarCharHolder right = helloLong;
        Assert.assertTrue((ByteFunctionHelpers.compare((DrillBuf)left.buffer, (int)left.start, (int)left.end, (DrillBuf)right.buffer, (int)right.start, (int)right.end) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualLong() {
        VarCharHolder left = helloLong;
        VarCharHolder right = helloLong;
        Assert.assertTrue((ByteFunctionHelpers.equal((DrillBuf)left.buffer, (int)left.start, (int)left.end, (DrillBuf)right.buffer, (int)right.start, (int)right.end) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testNotEqualLong() {
        VarCharHolder left = helloLong;
        VarCharHolder right = goodbyeLong;
        Assert.assertTrue((ByteFunctionHelpers.equal((DrillBuf)left.buffer, (int)left.start, (int)left.end, (DrillBuf)right.buffer, (int)right.start, (int)right.end) == 0 ? 1 : 0) != 0);
    }
}

