/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.fn.impl;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.PlanTestBase;
import org.apache.drill.common.util.TestTools;
import org.junit.Ignore;
import org.junit.Test;

public class TestAggregateFunctions
extends BaseTestQuery {
    private static final String TEST_RES_PATH = TestTools.getWorkingPath() + "/src/test/resources";

    @Test
    public void testCountOnNullableColumn() throws Exception {
        TestAggregateFunctions.testBuilder().sqlQuery("select count(t.x.y)  as cnt1, count(`integer`) as cnt2 from cp.`/jsoninput/input2.json` t").ordered().baselineColumns("cnt1", "cnt2").baselineValues(3L, 4L).build().run();
    }

    @Test
    public void testCountDistinctOnBoolColumn() throws Exception {
        TestAggregateFunctions.testBuilder().sqlQuery("select count(distinct `bool_val`) as cnt from `sys`.`options`").ordered().baselineColumns("cnt").baselineValues(2L).build().run();
    }

    @Test
    public void testMaxWithZeroInput() throws Exception {
        TestAggregateFunctions.testBuilder().sqlQuery("select max(employee_id * 0.0) as max_val from cp.`employee.json`").unOrdered().baselineColumns("max_val").baselineValues(0.0).go();
    }

    @Ignore
    @Test
    public void testDrill2092() throws Exception {
        String query = "select a1, b1, count(distinct c1) as dist1, \nsum(c1) as sum1, count(c1) as cnt1, count(*) as cnt \nfrom cp.`agg/bugs/drill2092/input.json` \ngroup by a1, b1 order by a1, b1";
        String baselineQuery = "select case when columns[0]='null' then cast(null as bigint) else cast(columns[0] as bigint) end as a1, \ncase when columns[1]='null' then cast(null as bigint) else cast(columns[1] as bigint) end as b1, \ncase when columns[2]='null' then cast(null as bigint) else cast(columns[2] as bigint) end as dist1, \ncase when columns[3]='null' then cast(null as bigint) else cast(columns[3] as bigint) end as sum1, \ncase when columns[4]='null' then cast(null as bigint) else cast(columns[4] as bigint) end as cnt1, \ncase when columns[5]='null' then cast(null as bigint) else cast(columns[5] as bigint) end as cnt \nfrom cp.`agg/bugs/drill2092/result.tsv`";
        TestAggregateFunctions.testBuilder().sqlQuery(query).ordered().optionSettingQueriesForTestQuery("alter system set `planner.enable_hashjoin` = true").sqlBaselineQuery(baselineQuery).build().run();
        TestAggregateFunctions.testBuilder().sqlQuery(query).ordered().optionSettingQueriesForTestQuery("alter system set `planner.enable_hashjoin` = false").sqlBaselineQuery(baselineQuery).build().run();
    }

    @Test
    public void testDrill2170() throws Exception {
        String query = "select count(*) as cnt from cp.`tpch/orders.parquet` o inner join\n(select l_orderkey, sum(l_quantity), sum(l_extendedprice) \nfrom cp.`tpch/lineitem.parquet` \ngroup by l_orderkey order by 3 limit 100) sq \non sq.l_orderkey = o.o_orderkey";
        TestAggregateFunctions.testBuilder().sqlQuery(query).ordered().optionSettingQueriesForTestQuery("alter system set `planner.slice_target` = 1000").baselineColumns("cnt").baselineValues(100L).build().run();
    }

    @Test
    public void testGBExprWithDrillFunc() throws Exception {
        TestAggregateFunctions.testBuilder().ordered().sqlQuery("select concat(n_name, cast(n_nationkey as varchar(10))) as name, count(*) as cnt from cp.`tpch/nation.parquet` group by concat(n_name, cast(n_nationkey as varchar(10))) having concat(n_name, cast(n_nationkey as varchar(10))) > 'UNITED'order by concat(n_name, cast(n_nationkey as varchar(10)))").baselineColumns("name", "cnt").baselineValues("UNITED KINGDOM23", 1L).baselineValues("UNITED STATES24", 1L).baselineValues("VIETNAM21", 1L).build().run();
    }

    @Test
    public void testDRILLNestedGBWithSubsetKeys() throws Exception {
        String sql = " select count(*) as cnt from (select l_partkey from\n   (select l_partkey, l_suppkey from cp.`tpch/lineitem.parquet`\n      group by l_partkey, l_suppkey) \n   group by l_partkey )";
        TestAggregateFunctions.test("alter session set `planner.slice_target` = 1; alter session set `planner.enable_multiphase_agg` = false ;");
        TestAggregateFunctions.testBuilder().ordered().sqlQuery(sql).baselineColumns("cnt").baselineValues(2000L).build().run();
        TestAggregateFunctions.test("alter session set `planner.slice_target` = 1; alter session set `planner.enable_multiphase_agg` = true ;");
        TestAggregateFunctions.testBuilder().ordered().sqlQuery(sql).baselineColumns("cnt").baselineValues(2000L).build().run();
        TestAggregateFunctions.test("alter session set `planner.slice_target` = 100000");
    }

    @Test
    public void testAvgWithNullableScalarFunction() throws Exception {
        String query = " select avg(length(b1)) as col from cp.`jsoninput/nullable1.json`";
        TestAggregateFunctions.testBuilder().sqlQuery(query).unOrdered().baselineColumns("col").baselineValues(3.0).go();
    }

    @Test
    public void testCountWithAvg() throws Exception {
        TestAggregateFunctions.testBuilder().sqlQuery("select count(a) col1, avg(b) col2 from cp.`jsoninput/nullable3.json`").unOrdered().baselineColumns("col1", "col2").baselineValues(2L, 3.0).go();
        TestAggregateFunctions.testBuilder().sqlQuery("select count(a) col1, avg(a) col2 from cp.`jsoninput/nullable3.json`").unOrdered().baselineColumns("col1", "col2").baselineValues(2L, 1.0).go();
    }

    @Test
    public void testAvgOnKnownType() throws Exception {
        TestAggregateFunctions.testBuilder().sqlQuery("select avg(cast(employee_id as bigint)) as col from cp.`employee.json`").unOrdered().baselineColumns("col").baselineValues(578.9982683982684).go();
    }

    @Test
    public void testStddevOnKnownType() throws Exception {
        TestAggregateFunctions.testBuilder().sqlQuery("select stddev_samp(cast(employee_id as int)) as col from cp.`employee.json`").unOrdered().baselineColumns("col").baselineValues(333.56708470261117).go();
    }

    @Test
    public void testAggregateWithEmptyInput() throws Exception {
        String query = "select count(employee_id) col1, avg(employee_id) col2, sum(employee_id) col3 from cp.`employee.json` where 1 = 0";
        TestAggregateFunctions.testBuilder().sqlQuery(query).unOrdered().baselineColumns("col1", "col2", "col3").baselineValues(0L, null, null).go();
    }

    @Test
    public void testAggregateWithEmptyRequiredInput() throws Exception {
        String query = "select min(bool_col) col1, min(int_col) col2, min(bigint_col) col3, min(float4_col) col4, min(float8_col) col5, min(date_col) col6, min(time_col) col7, min(timestamp_col) col8, min(interval_year_col) col9, min(varhcar_col) col10 from cp.`parquet/alltypes_required.parquet` where 1 = 0";
        TestAggregateFunctions.testBuilder().sqlQuery(query).unOrdered().baselineColumns("col1", "col2", "col3", "col4", "col5", "col6", "col7", "col8", "col9", "col10").baselineValues(null, null, null, null, null, null, null, null, null, null).go();
        query = "select max(int_col) col1, max(bigint_col) col2, max(float4_col) col3, max(float8_col) col4, max(date_col) col5, max(time_col) col6, max(timestamp_col) col7, max(interval_year_col) col8, max(varhcar_col) col9 from cp.`parquet/alltypes_required.parquet` where 1 = 0";
        TestAggregateFunctions.testBuilder().sqlQuery(query).unOrdered().baselineColumns("col1", "col2", "col3", "col4", "col5", "col6", "col7", "col8", "col9").baselineValues(null, null, null, null, null, null, null, null, null).go();
        query = "select sum(int_col) col1, sum(bigint_col) col2, sum(float4_col) col3, sum(float8_col) col4, sum(interval_year_col) col5 from cp.`employee.json` where 1 = 0";
        TestAggregateFunctions.testBuilder().sqlQuery(query).unOrdered().baselineColumns("col1", "col2", "col3", "col4", "col5").baselineValues(null, null, null, null, null).go();
        query = "select avg(int_col) col1, avg(bigint_col) col2, avg(float4_col) col3, avg(float8_col) col4, avg(interval_year_col) col5 from cp.`employee.json` where 1 = 0";
        TestAggregateFunctions.testBuilder().sqlQuery(query).unOrdered().baselineColumns("col1", "col2", "col3", "col4", "col5").baselineValues(null, null, null, null, null).go();
        query = "select stddev_pop(int_col) col1, stddev_pop(bigint_col) col2, stddev_pop(float4_col) col3, stddev_pop(float8_col) col4, stddev_pop(interval_year_col) col5 from cp.`employee.json` where 1 = 0";
        TestAggregateFunctions.testBuilder().sqlQuery(query).unOrdered().baselineColumns("col1", "col2", "col3", "col4", "col5").baselineValues(null, null, null, null, null).go();
    }

    @Test
    public void drill3069() throws Exception {
        String query = "select max(foo) col1 from dfs_test.`%s/agg/bugs/drill3069` where foo = %d";
        TestAggregateFunctions.testBuilder().sqlQuery(String.format("select max(foo) col1 from dfs_test.`%s/agg/bugs/drill3069` where foo = %d", TEST_RES_PATH, 2)).unOrdered().baselineColumns("col1").baselineValues(2L).go();
        TestAggregateFunctions.testBuilder().sqlQuery(String.format("select max(foo) col1 from dfs_test.`%s/agg/bugs/drill3069` where foo = %d", TEST_RES_PATH, 4)).unOrdered().baselineColumns("col1").baselineValues(4L).go();
        TestAggregateFunctions.testBuilder().sqlQuery(String.format("select max(foo) col1 from dfs_test.`%s/agg/bugs/drill3069` where foo = %d", TEST_RES_PATH, 6)).unOrdered().baselineColumns("col1").baselineValues(6L).go();
    }

    @Test
    public void testPushFilterPastAgg() throws Exception {
        String query = " select cnt  from (select n_regionkey, count(*) cnt from cp.`tpch/nation.parquet` group by n_regionkey)  where n_regionkey = 2 ";
        String[] expectedPlan = new String[]{"(?s)(StreamAgg|HashAgg).*Filter"};
        String[] excludedPatterns = new String[]{"(?s)Filter.*(StreamAgg|HashAgg)"};
        PlanTestBase.testPlanMatchingPatterns(" select cnt  from (select n_regionkey, count(*) cnt from cp.`tpch/nation.parquet` group by n_regionkey)  where n_regionkey = 2 ", expectedPlan, excludedPatterns);
        TestAggregateFunctions.testBuilder().sqlQuery(" select cnt  from (select n_regionkey, count(*) cnt from cp.`tpch/nation.parquet` group by n_regionkey)  where n_regionkey = 2 ").unOrdered().baselineColumns("cnt").baselineValues(5L).build().run();
        String query2 = " select count(*) cnt from cp.`tpch/nation.parquet` group by n_regionkey  having n_regionkey = 2 ";
        PlanTestBase.testPlanMatchingPatterns(" select count(*) cnt from cp.`tpch/nation.parquet` group by n_regionkey  having n_regionkey = 2 ", expectedPlan, excludedPatterns);
        TestAggregateFunctions.testBuilder().sqlQuery(" select cnt  from (select n_regionkey, count(*) cnt from cp.`tpch/nation.parquet` group by n_regionkey)  where n_regionkey = 2 ").unOrdered().baselineColumns("cnt").baselineValues(5L).build().run();
    }

    @Test
    public void testPushFilterInExprPastAgg() throws Exception {
        String query = " select cnt  from (select n_regionkey, count(*) cnt from cp.`tpch/nation.parquet` group by n_regionkey)  where n_regionkey + 100 - 100 = 2 ";
        String[] expectedPlan = new String[]{"(?s)(StreamAgg|HashAgg).*Filter"};
        String[] excludedPatterns = new String[]{"(?s)Filter.*(StreamAgg|HashAgg)"};
        PlanTestBase.testPlanMatchingPatterns(" select cnt  from (select n_regionkey, count(*) cnt from cp.`tpch/nation.parquet` group by n_regionkey)  where n_regionkey + 100 - 100 = 2 ", expectedPlan, excludedPatterns);
        TestAggregateFunctions.testBuilder().sqlQuery(" select cnt  from (select n_regionkey, count(*) cnt from cp.`tpch/nation.parquet` group by n_regionkey)  where n_regionkey + 100 - 100 = 2 ").unOrdered().baselineColumns("cnt").baselineValues(5L).build().run();
    }

    @Test
    public void testNegPushFilterInExprPastAgg() throws Exception {
        String query = " select cnt  from (select n_regionkey, count(*) cnt from cp.`tpch/nation.parquet` group by n_regionkey)  where cnt + 100 - 100 = 5 ";
        String[] expectedPlan = new String[]{"(?s)Filter(?!StreamAgg|!HashAgg)"};
        String[] excludedPatterns = new String[]{"(?s)(StreamAgg|HashAgg).*Filter"};
        PlanTestBase.testPlanMatchingPatterns(" select cnt  from (select n_regionkey, count(*) cnt from cp.`tpch/nation.parquet` group by n_regionkey)  where cnt + 100 - 100 = 5 ", expectedPlan, excludedPatterns);
        String query2 = " select cnt  from (select n_regionkey, count(*) cnt from cp.`tpch/nation.parquet` group by n_regionkey)  where cnt + n_regionkey = 5 ";
        PlanTestBase.testPlanMatchingPatterns(" select cnt  from (select n_regionkey, count(*) cnt from cp.`tpch/nation.parquet` group by n_regionkey)  where cnt + n_regionkey = 5 ", expectedPlan, excludedPatterns);
    }

    @Test
    public void testGroupBySystemFuncSchemaTable() throws Exception {
        String query = "select count(*) as cnt from sys.version group by CURRENT_DATE";
        String[] expectedPlan = new String[]{"(?s)(StreamAgg|HashAgg)"};
        String[] excludedPatterns = new String[]{};
        PlanTestBase.testPlanMatchingPatterns("select count(*) as cnt from sys.version group by CURRENT_DATE", expectedPlan, excludedPatterns);
    }

    @Test
    public void testGroupBySystemFuncFileSystemTable() throws Exception {
        String query = String.format("select count(*) as cnt from dfs_test.`%s/nation/nation.tbl` group by CURRENT_DATE", TEST_RES_PATH);
        TestAggregateFunctions.testBuilder().sqlQuery(query).unOrdered().baselineColumns("cnt").baselineValues(25L).build().run();
        String query2 = "select count(*) as cnt from cp.`tpch/nation.parquet` group by CURRENT_DATE";
        TestAggregateFunctions.testBuilder().sqlQuery("select count(*) as cnt from cp.`tpch/nation.parquet` group by CURRENT_DATE").unOrdered().baselineColumns("cnt").baselineValues(25L).build().run();
        String query3 = "select count(*) as cnt from cp.`employee.json` group by CURRENT_DATE";
        TestAggregateFunctions.testBuilder().sqlQuery("select count(*) as cnt from cp.`employee.json` group by CURRENT_DATE").unOrdered().baselineColumns("cnt").baselineValues(1155L).build().run();
    }
}

