/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.fn.impl;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Assert;
import org.junit.Test;

public class TestAggregateFunction
extends PopUnitTestBase {
    public void runTest(Object[] values, String planPath, String dataPath) throws Throwable {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)planPath), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", dataPath));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(1);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            int i = 0;
            for (VectorWrapper v : batchLoader) {
                ValueVector.Accessor accessor = v.getValueVector().getAccessor();
                Assert.assertEquals((Object)values[i++], (Object)accessor.getObject(0));
            }
            batchLoader.clear();
            for (QueryDataBatch b : results) {
                b.release();
            }
        }
    }

    @Test
    public void testSortDate() throws Throwable {
        String planPath = "/functions/test_stddev_variance.json";
        String dataPath = "/simple_stddev_variance_input.json";
        Object[] expectedValues = new Double[]{2.0, 2.138089935299395, 2.138089935299395, 4.0, 4.571428571428571, 4.571428571428571};
        this.runTest(expectedValues, planPath, dataPath);
    }

    @Test
    public void testCovarianceCorrelation() throws Throwable {
        String planPath = "/functions/test_covariance.json";
        String dataPath = "/covariance_input.json";
        Object[] expectedValues = new Double[]{4.571428571428571, 4.857142857142857, -6.000000000000002, 4.0, 4.25, -5.250000000000002, 1.0, 0.9274260335029677, -1.0000000000000004};
        this.runTest(expectedValues, planPath, dataPath);
    }
}

