/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.fn.impl;

import java.util.Random;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Float8Holder;

public class GeneratorFunctions
extends ExecTest {
    public static final Random random = new Random(1234L);

    @FunctionTemplate(name="randomFloat8", isRandom=true, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RandomFloat8
    implements DrillSimpleFunc {
        @Param
        BigIntHolder min;
        @Param
        BigIntHolder max;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = random.nextFloat() * (float)(this.max.value - this.min.value) + (float)this.min.value;
        }
    }

    @FunctionTemplate(name="randomFloat8", isRandom=true, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RandomFloat8Gauss
    implements DrillSimpleFunc {
        @Param
        BigIntHolder range;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = random.nextGaussian() * (double)this.range.value;
        }
    }

    @FunctionTemplate(name="randomBigInt", isRandom=true, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RandomBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder min;
        @Param
        BigIntHolder max;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = (long)(random.nextFloat() * (float)(this.max.value - this.min.value) + (float)this.min.value);
        }
    }

    @FunctionTemplate(name="randomBigInt", isRandom=true, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class RandomBigIntGauss
    implements DrillSimpleFunc {
        @Param
        BigIntHolder range;
        @Output
        BigIntHolder out;

        public void setup() {
        }

        public void eval() {
            this.out.value = (long)(random.nextGaussian() * (double)this.range.value);
        }
    }

    @FunctionTemplate(name="increasingBigInt", isRandom=true, scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class IncreasingBigInt
    implements DrillSimpleFunc {
        @Param
        BigIntHolder start;
        @Workspace
        long current;
        @Output
        BigIntHolder out;

        public void setup() {
            this.current = 0L;
        }

        public void eval() {
            this.out.value = this.start.value + this.current++;
        }
    }
}

