/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import com.google.common.base.Charsets;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.joda.time.Period;

@FunctionTemplate(name="castINTERVAL", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastVarCharToInterval
implements DrillSimpleFunc {
    @Param
    VarCharHolder in;
    @Output
    IntervalHolder out;

    public void setup() {
    }

    public void eval() {
        byte[] buf = new byte[this.in.end - this.in.start];
        this.in.buffer.getBytes(this.in.start, buf, 0, this.in.end - this.in.start);
        String input = new String(buf, Charsets.UTF_8);
        Period period = Period.parse((String)input);
        this.out.months = period.getYears() * 12 + period.getMonths();
        this.out.days = period.getDays();
        this.out.milliseconds = period.getHours() * 3600000 + period.getMinutes() * 60000 + period.getSeconds() * 1000 + period.getMillis();
    }
}

