/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import com.google.common.base.Charsets;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castDECIMAL9", scope=FunctionTemplate.FunctionScope.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastVarCharDecimal9
implements DrillSimpleFunc {
    @Param
    VarCharHolder in;
    @Param
    BigIntHolder precision;
    @Param
    BigIntHolder scale;
    @Output
    Decimal9Holder out;

    public void setup() {
    }

    public void eval() {
        int fractionalDigits;
        this.out.scale = (int)this.scale.value;
        this.out.precision = (int)this.precision.value;
        int endIndex = this.in.end;
        int readIndex = this.in.start;
        if (endIndex - readIndex == 0) {
            throw new DrillRuntimeException("Empty String, cannot cast to Decimal");
        }
        int scaleIndex = -1;
        boolean negative = false;
        byte next = this.in.buffer.getByte(readIndex);
        if (next == 45) {
            negative = true;
            ++readIndex;
        }
        int integerStartIndex = readIndex;
        int integerEndIndex = endIndex;
        boolean leadingDigitFound = false;
        boolean round = false;
        int radix = 10;
        while (readIndex < endIndex) {
            if ((next = this.in.buffer.getByte(readIndex++)) == 46) {
                scaleIndex = readIndex;
                integerEndIndex = scaleIndex - 1;
                if (scaleIndex + this.out.scale >= endIndex) continue;
                endIndex = scaleIndex + this.out.scale;
                round = true;
                continue;
            }
            if ((next = (byte)Character.digit(next, radix)) == -1) {
                byte[] buf = new byte[this.in.end - this.in.start];
                this.in.buffer.getBytes(this.in.start, buf, 0, this.in.end - this.in.start);
                throw new DrillRuntimeException(new String(buf, Charsets.UTF_8));
            }
            if (!leadingDigitFound) {
                if (next == 0) {
                    ++integerStartIndex;
                } else {
                    leadingDigitFound = true;
                }
            }
            this.out.value *= radix;
            this.out.value += next;
        }
        if (integerEndIndex - integerStartIndex + this.out.scale > this.out.precision) {
            byte[] buf = new byte[this.in.end - this.in.start];
            this.in.buffer.getBytes(this.in.start, buf, 0, this.in.end - this.in.start);
            throw new DrillRuntimeException("Precision is insufficient for the provided input: " + new String(buf, Charsets.UTF_8) + " Precision: " + this.out.precision + " Total Digits: " + (this.out.scale + (integerEndIndex - integerStartIndex)));
        }
        if (round) {
            next = this.in.buffer.getByte(endIndex);
            if ((next = (byte)Character.digit(next, radix)) == -1) {
                byte[] buf = new byte[this.in.end - this.in.start];
                this.in.buffer.getBytes(this.in.start, buf, 0, this.in.end - this.in.start);
                throw new DrillRuntimeException(new String(buf, Charsets.UTF_8));
            }
            if (next > 4) {
                ++this.out.value;
            }
        }
        int n = fractionalDigits = scaleIndex == -1 ? 0 : endIndex - scaleIndex;
        if ((long)fractionalDigits < this.scale.value) {
            this.out.value = (int)DecimalUtility.adjustScaleMultiply((long)this.out.value, (int)((int)(this.scale.value - (long)fractionalDigits)));
        }
        if (negative) {
            this.out.value *= -1;
        }
    }
}

