/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalTime;

@FunctionTemplate(name="castVARCHAR", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, costCategory=FunctionTemplate.FunctionCostCategory.COMPLEX)
public class CastTimeToVarChar
implements DrillSimpleFunc {
    @Param
    TimeHolder in;
    @Param
    BigIntHolder len;
    @Inject
    DrillBuf buffer;
    @Output
    VarCharHolder out;

    public void setup() {
        this.buffer = this.buffer.reallocIfNeeded((int)this.len.value);
    }

    public void eval() {
        LocalTime temp = new LocalTime((long)this.in.value, DateTimeZone.UTC);
        String str = temp.toString();
        this.out.buffer = this.buffer;
        this.out.start = 0;
        this.out.end = Math.min((int)this.len.value, str.length());
        this.out.buffer.setBytes(0, str.substring(0, this.out.end).getBytes());
    }
}

