/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.impl.DateUtility;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;

@FunctionTemplate(name="castVARCHAR", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, costCategory=FunctionTemplate.FunctionCostCategory.COMPLEX)
public class CastTimeStampToVarChar
implements DrillSimpleFunc {
    @Param
    TimeStampHolder in;
    @Param
    BigIntHolder len;
    @Inject
    DrillBuf buffer;
    @Output
    VarCharHolder out;

    public void setup() {
        this.buffer = this.buffer.reallocIfNeeded((int)this.len.value);
    }

    public void eval() {
        MutableDateTime temp = new MutableDateTime(this.in.value, DateTimeZone.UTC);
        String str = DateUtility.formatTimeStamp.print((ReadableInstant)temp);
        this.out.buffer = this.buffer;
        this.out.start = 0;
        this.out.end = Math.min((int)this.len.value, str.length());
        this.out.buffer.setBytes(0, str.substring(0, this.out.end).getBytes());
    }
}

