/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

@FunctionTemplate(name="castVARCHAR", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastIntervalToVarChar
implements DrillSimpleFunc {
    @Param
    IntervalHolder in;
    @Param
    BigIntHolder len;
    @Inject
    DrillBuf buffer;
    @Output
    VarCharHolder out;

    public void setup() {
        this.buffer.reallocIfNeeded(65);
    }

    public void eval() {
        int years = this.in.months / 12;
        int months = this.in.months % 12;
        long millis = this.in.milliseconds;
        long hours = millis / 3600000L;
        long minutes = (millis %= 3600000L) / 60000L;
        long seconds = (millis %= 60000L) / 1000L;
        String yearString = Math.abs(years) == 1 ? " year " : " years ";
        String monthString = Math.abs(months) == 1 ? " month " : " months ";
        String dayString = Math.abs(this.in.days) == 1 ? " day " : " days ";
        StringBuilder str = new StringBuilder().append(years).append(yearString).append(months).append(monthString).append(this.in.days).append(dayString).append(hours).append(":").append(minutes).append(":").append(seconds).append(".").append(millis %= 1000L);
        this.out.buffer = this.buffer;
        this.out.start = 0;
        this.out.end = Math.min((int)this.len.value, str.length());
        this.out.buffer.setBytes(0, String.valueOf(str.substring(0, this.out.end)).getBytes());
    }
}

