/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;

@FunctionTemplate(name="castVARCHAR", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL, costCategory=FunctionTemplate.FunctionCostCategory.COMPLEX)
public class CastIntervalDayToVarChar
implements DrillSimpleFunc {
    @Param
    IntervalDayHolder in;
    @Param
    BigIntHolder len;
    @Inject
    DrillBuf buffer;
    @Output
    VarCharHolder out;

    public void setup() {
        this.buffer = this.buffer.reallocIfNeeded((int)this.len.value);
    }

    public void eval() {
        long millis = this.in.milliseconds;
        long hours = millis / 3600000L;
        long minutes = (millis %= 3600000L) / 60000L;
        long seconds = (millis %= 60000L) / 1000L;
        String dayString = Math.abs(this.in.days) == 1 ? " day " : " days ";
        StringBuilder str = new StringBuilder().append(this.in.days).append(dayString).append(hours).append(":").append(minutes).append(":").append(seconds).append(".").append(millis %= 1000L);
        this.out.buffer = this.buffer;
        this.out.start = 0;
        this.out.end = Math.min((int)this.len.value, str.length());
        this.out.buffer.setBytes(0, String.valueOf(str.substring(0, this.out.end)).getBytes());
    }
}

