/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castDECIMAL9", scope=FunctionTemplate.FunctionScope.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastIntDecimal9
implements DrillSimpleFunc {
    @Param
    IntHolder in;
    @Param
    BigIntHolder precision;
    @Param
    BigIntHolder scale;
    @Output
    Decimal9Holder out;

    public void setup() {
    }

    public void eval() {
        this.out.scale = (int)this.scale.value;
        this.out.precision = (int)this.precision.value;
        this.out.value = this.in.value;
        this.out.value = (int)DecimalUtility.adjustScaleMultiply((long)this.out.value, (int)((int)this.scale.value));
    }
}

