/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;

@FunctionTemplate(name="castINT", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastFloat8Int
implements DrillSimpleFunc {
    @Param
    Float8Holder in;
    @Output
    IntHolder out;

    public void setup() {
    }

    public void eval() {
        boolean sign = this.in.value < 0.0;
        this.in.value = Math.abs(this.in.value);
        double fractional = this.in.value % 1.0;
        int digit = (int)(fractional * 10.0);
        int carry = 0;
        if (digit > 4) {
            carry = 1;
        }
        this.out.value = (int)this.in.value + carry;
        if (sign) {
            this.out.value *= -1;
        }
    }
}

