/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import javax.inject.Inject;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castDECIMAL28SPARSE", scope=FunctionTemplate.FunctionScope.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastFloat8Decimal28Sparse
implements DrillSimpleFunc {
    @Param
    Float8Holder in;
    @Inject
    DrillBuf buffer;
    @Param
    BigIntHolder precision;
    @Param
    BigIntHolder scale;
    @Output
    Decimal28SparseHolder out;

    public void setup() {
        int size = 20;
        this.buffer = this.buffer.reallocIfNeeded(size);
    }

    public void eval() {
        this.out.scale = (int)this.scale.value;
        this.out.precision = (int)this.precision.value;
        this.out.start = 0;
        this.out.buffer = this.buffer;
        DecimalUtility.getSparseFromBigDecimal((BigDecimal)new BigDecimal(String.valueOf(this.in.value)), (DrillBuf)this.out.buffer, (int)this.out.start, (int)this.out.scale, (int)this.out.precision, (int)5);
    }
}

