/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.Float8Holder;

@FunctionTemplate(name="castBIGINT", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
public class CastFloat8BigInt
implements DrillSimpleFunc {
    @Param
    Float8Holder in;
    @Output
    BigIntHolder out;

    public void setup() {
    }

    public void eval() {
        boolean sign = this.in.value < 0.0;
        this.in.value = Math.abs(this.in.value);
        double fractional = this.in.value % 1.0;
        int digit = (int)(fractional * 10.0);
        int carry = 0;
        if (digit > 4) {
            carry = 1;
        }
        this.out.value = (long)this.in.value + (long)carry;
        if (sign) {
            this.out.value *= -1L;
        }
    }
}

