/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.gcast;

import com.google.common.base.Charsets;
import io.netty.buffer.DrillBuf;
import javax.inject.Inject;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal28SparseHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.util.DecimalUtility;

@FunctionTemplate(name="castEmptyStringVarCharToNullableDECIMAL28SPARSE", scope=FunctionTemplate.FunctionScope.DECIMAL_CAST, nulls=FunctionTemplate.NullHandling.INTERNAL)
public class CastEmptyStringVarCharToNullableDecimal28Sparse
implements DrillSimpleFunc {
    @Param
    VarCharHolder in;
    @Inject
    DrillBuf buffer;
    @Param
    BigIntHolder precision;
    @Param
    BigIntHolder scale;
    @Output
    NullableDecimal28SparseHolder out;

    public void setup() {
        int size = 20;
        this.buffer = this.buffer.reallocIfNeeded(size);
    }

    public void eval() {
        int value;
        int integerEndIndex;
        if (this.in.end == this.in.start) {
            this.out.isSet = 0;
            return;
        }
        this.out.isSet = 1;
        this.out.buffer = this.buffer;
        this.out.start = 0;
        this.out.scale = (int)this.scale.value;
        this.out.precision = (int)this.precision.value;
        boolean sign = false;
        for (int i = 0; i < 5; ++i) {
            NullableDecimal28SparseHolder.setInteger(i, 0, this.out.start, this.out.buffer);
        }
        int readIndex = this.in.start;
        int integerDigits = 0;
        boolean fractionalDigits = false;
        int scaleIndex = -1;
        int scaleEndIndex = this.in.end;
        byte[] buf1 = new byte[this.in.end - this.in.start];
        this.in.buffer.getBytes(this.in.start, buf1, 0, this.in.end - this.in.start);
        Byte next = this.in.buffer.getByte(readIndex);
        if (next == 45) {
            ++readIndex;
            sign = true;
        }
        if (next == 46) {
            scaleIndex = ++readIndex;
        }
        int startIndex = readIndex;
        int radix = 10;
        boolean leadingDigitFound = false;
        boolean round = false;
        if (scaleIndex == -1) {
            while (readIndex < this.in.end) {
                if ((next = Byte.valueOf(this.in.buffer.getByte(readIndex++))) == 46) {
                    scaleIndex = readIndex;
                    if (this.in.end - scaleIndex <= this.out.scale) break;
                    scaleEndIndex = scaleIndex + this.out.scale;
                    round = true;
                    break;
                }
                if ((next = Byte.valueOf((byte)Character.digit(next.byteValue(), radix))) == -1) {
                    byte[] buf = new byte[this.in.end - this.in.start];
                    this.in.buffer.getBytes(this.in.start, buf, 0, this.in.end - this.in.start);
                    throw new NumberFormatException(new String(buf, Charsets.UTF_8));
                }
                if (!leadingDigitFound && next != 0) {
                    leadingDigitFound = true;
                }
                if (!leadingDigitFound) continue;
                ++integerDigits;
            }
        }
        if (integerDigits + this.out.scale > this.out.precision) {
            byte[] buf = new byte[this.in.end - this.in.start];
            this.in.buffer.getBytes(this.in.start, buf, 0, this.in.end - this.in.start);
            throw new DrillRuntimeException("Precision is insufficient for the provided input: " + new String(buf, Charsets.UTF_8) + " Precision: " + this.out.precision + " Total Digits: " + (this.out.scale + integerDigits));
        }
        int scaleRoundedUp = DecimalUtility.roundUp((int)this.out.scale);
        int integerRoundedUp = DecimalUtility.roundUp((int)integerDigits);
        int ndigits = 0;
        int decimalBufferIndex = 5 - scaleRoundedUp - 1;
        int n = integerEndIndex = scaleIndex == -1 ? this.in.end - 1 : scaleIndex - 2;
        while (integerEndIndex >= startIndex) {
            next = this.in.buffer.getByte(integerEndIndex--);
            next = (byte)Character.digit(next.byteValue(), radix);
            value = (int)DecimalUtility.getPowerOfTen((int)ndigits) * next + NullableDecimal28SparseHolder.getInteger(decimalBufferIndex, this.out.start, this.out.buffer);
            NullableDecimal28SparseHolder.setInteger(decimalBufferIndex, value, this.out.start, this.out.buffer);
            if (++ndigits < 9) continue;
            ndigits = 0;
            --decimalBufferIndex;
        }
        decimalBufferIndex = scaleRoundedUp > 0 ? 5 - scaleRoundedUp : 4;
        ndigits = 0;
        if (scaleIndex != -1) {
            while (scaleIndex < scaleEndIndex) {
                if (ndigits >= 9) {
                    ndigits = 0;
                    ++decimalBufferIndex;
                }
                next = this.in.buffer.getByte(scaleIndex++);
                if ((next = Byte.valueOf((byte)Character.digit(next.byteValue(), radix))) == -1) {
                    byte[] buf = new byte[this.in.end - this.in.start];
                    this.in.buffer.getBytes(this.in.start, buf, 0, this.in.end - this.in.start);
                    throw new NumberFormatException(new String(buf, Charsets.UTF_8));
                }
                value = NullableDecimal28SparseHolder.getInteger(decimalBufferIndex, this.out.start, this.out.buffer) * radix + next;
                NullableDecimal28SparseHolder.setInteger(decimalBufferIndex, value, this.out.start, this.out.buffer);
                ++ndigits;
            }
            if (round) {
                next = this.in.buffer.getByte(scaleEndIndex);
                if ((next = Byte.valueOf((byte)Character.digit(next.byteValue(), radix))) == -1) {
                    byte[] buf = new byte[this.in.end - this.in.start];
                    this.in.buffer.getBytes(this.in.start, buf, 0, this.in.end - this.in.start);
                    throw new NumberFormatException(new String(buf, Charsets.UTF_8));
                }
                if (next > 4) {
                    NullableDecimal28SparseHolder.setInteger(decimalBufferIndex, NullableDecimal28SparseHolder.getInteger(decimalBufferIndex, this.out.start, this.out.buffer) + 1, this.out.start, this.out.buffer);
                }
            }
            if (this.out.scale > 0) {
                int padding = (int)DecimalUtility.getPowerOfTen((int)(9 - ndigits));
                NullableDecimal28SparseHolder.setInteger(decimalBufferIndex, NullableDecimal28SparseHolder.getInteger(decimalBufferIndex, this.out.start, this.out.buffer) * padding, this.out.start, this.out.buffer);
            }
            int carry = 0;
            do {
                int tempValue = NullableDecimal28SparseHolder.getInteger(decimalBufferIndex, this.out.start, this.out.buffer) + carry;
                if (tempValue >= 1000000000) {
                    carry = tempValue / 1000000000;
                    tempValue %= 1000000000;
                } else {
                    carry = 0;
                }
                NullableDecimal28SparseHolder.setInteger(decimalBufferIndex--, tempValue, this.out.start, this.out.buffer);
            } while (carry > 0 && decimalBufferIndex >= 0);
        }
        NullableDecimal28SparseHolder.setSign(sign, this.out.start, this.out.buffer);
    }
}

